package com.namasoft.common.layout.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.NaMaDTO;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOAbstractParamsMapping extends NaMaDTO
{
	private PMap p1;
	private PMap p2;
	private PMap p3;
	private PMap p4;
	private PMap p5;
	private PMap p6;
	private PMap p7;
	private PMap p8;
	private PMap p9;

	public PMap getP1()
	{
		return p1;
	}

	public void setP1(PMap p1)
	{
		this.p1 = p1;
	}

	public PMap getP2()
	{
		return p2;
	}

	public void setP2(PMap p2)
	{
		this.p2 = p2;
	}

	public PMap getP3()
	{
		return p3;
	}

	public void setP3(PMap p3)
	{
		this.p3 = p3;
	}

	public PMap getP4()
	{
		return p4;
	}

	public void setP4(PMap p4)
	{
		this.p4 = p4;
	}

	public PMap getP5()
	{
		return p5;
	}

	public void setP5(PMap p5)
	{
		this.p5 = p5;
	}

	public PMap getP6()
	{
		return p6;
	}

	public void setP6(PMap p6)
	{
		this.p6 = p6;
	}

	public PMap getP7()
	{
		return p7;
	}

	public void setP7(PMap p7)
	{
		this.p7 = p7;
	}

	public PMap getP8()
	{
		return p8;
	}

	public void setP8(PMap p8)
	{
		this.p8 = p8;
	}

	public PMap getP9()
	{
		return p9;
	}

	public void setP9(PMap p9)
	{
		this.p9 = p9;
	}

	public HashMap<String, String> parameterFieldMap()
	{
		HashMap<String, String> map = new HashMap<String, String>();
		add(getP1(), map);
		add(getP2(), map);
		add(getP3(), map);
		add(getP4(), map);
		add(getP5(), map);
		add(getP6(), map);
		add(getP7(), map);
		add(getP8(), map);
		add(getP9(), map);
		return map;
	}

	private void add(PMap p, HashMap<String, String> map)
	{
		if (ObjectChecker.isNotEmptyOrNull(p.getField()))
			map.put(p.getParameter(), p.getField());
	}

	public List<String> collectFields()
	{
		ArrayList<String> fields = new ArrayList<String>();
		add(getP1(), fields);
		add(getP2(), fields);
		add(getP3(), fields);
		add(getP4(), fields);
		add(getP5(), fields);
		add(getP6(), fields);
		add(getP7(), fields);
		add(getP8(), fields);
		add(getP9(), fields);
		return fields;
	}

	private void add(PMap p, ArrayList<String> fields)
	{
		if (p != null && ObjectChecker.isNotEmptyOrNull(p.getField()))
			fields.add(p.getField());
	}

	public void overrideQuestionsIfNeeded(List<DTOFilledQuestionField> questionFields, List<DTOFilledQuestionField> questionsFromMapping)
	{
		for (DTOFilledQuestionField dtoFilledQuestionField : questionsFromMapping)
		{
			if (shouldOverrideQuestoin(dtoFilledQuestionField.getId()))
			{
				int index = HasIDUtil.indexOf(dtoFilledQuestionField.getId(), questionFields);
				if (index > 0)
					questionFields.remove(index);
				questionFields.add(dtoFilledQuestionField);
			}
		}
	}

	public List<String> getHiddenParameters()
	{
		List<String> hidden = new ArrayList<String>();
		for (String param : parameterFieldMap().keySet())
		{
			if (shouldOverrideQuestoin(param))
				hidden.add(param);
		}
		return hidden;
	}

	private boolean shouldOverrideQuestoin(String id)
	{
		PMap mapping = findMappingByParamId(id);
		if (mapping != null)
			return mapping.isAlwaysOverride();
		return false;
	}

	private PMap findMappingByParamId(String id)
	{
		return find(id, getP1(), getP2(), getP3(), getP4(), getP5(), getP6(), getP7(), getP8(), getP9());
	}

	private PMap find(String id, PMap... ps)
	{
		for (PMap pMap : ps)
		{
			if (pMap != null && ObjectChecker.areEqual(pMap.getParameter(), id))
				return pMap;
		}
		return null;
	}
}
