package com.namasoft.common.layout.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TooltipMetadata extends NaMaDTO
{
	private List<FieldTooltipInfo> fieldTooltips = new ArrayList<FieldTooltipInfo>();
	private HashMap<String, FieldTooltipInfoRefList> defaultTooltips = new HashMap<>();
	private HashMap<EntityFieldPair, FieldTooltipInfoRefList> fieldsTooltips = new HashMap<>();

	public List<FieldTooltipInfo> getFieldTooltips()
	{
		return fieldTooltips;
	}

	public void setFieldTooltips(List<FieldTooltipInfo> fieldTooltips)
	{
		this.fieldTooltips = fieldTooltips;
	}

	public HashMap<String, FieldTooltipInfoRefList> getDefaultTooltips()
	{
		return defaultTooltips;
	}

	public void setDefaultTooltips(HashMap<String, FieldTooltipInfoRefList> defaultTooltips)
	{
		this.defaultTooltips = defaultTooltips;
	}

	public HashMap<EntityFieldPair, FieldTooltipInfoRefList> getFieldsTooltips()
	{
		return fieldsTooltips;
	}

	public void setFieldsTooltips(HashMap<EntityFieldPair, FieldTooltipInfoRefList> fieldsTooltips)
	{
		this.fieldsTooltips = fieldsTooltips;
	}

	public List<FieldTooltipInfo> getFieldTooltip(String entityType, String field)
	{
		FieldTooltipInfoRefList fieldTooltips = getFieldsTooltips().get(EntityFieldPair.of(entityType, field));
		FieldTooltipInfoRefList defaultTooltips = getDefaultTooltips().get(field);
		return get(CollectionsUtility
				.join(fieldTooltips == null ? null : fieldTooltips.getList(), defaultTooltips == null ? null : defaultTooltips.getList()));
	}

	private List<FieldTooltipInfo> get(List<FieldTooltipInfoRef> refs)
	{
		if (ObjectChecker.isEmptyOrNull(refs))
			return null;
		return refs.stream().map(r -> getFieldTooltips().get(r.getIndex())).collect(Collectors.toList());
	}

}
