package com.namasoft.common.utilities;

import org.apache.logging.log4j.core.*;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.*;
import org.apache.logging.log4j.core.config.plugins.*;
import org.apache.logging.log4j.core.layout.PatternLayout;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;

@Plugin(name = "NaMaPerSessionLogAppender", category = Core.CATEGORY_NAME, elementType = Appender.ELEMENT_TYPE)
public class NaMaPerSessionLogAppender extends AbstractAppender
{
	protected NaMaPerSessionLogAppender(String name, org.apache.logging.log4j.core.Filter filter, Layout<? extends Serializable> layout)
	{
		super(name, filter, layout, false, null);
	}

	@PluginFactory
	public static NaMaPerSessionLogAppender createAppender(@PluginAttribute("name") String name,
			@PluginElement("Layout") Layout<? extends Serializable> layout, @PluginElement("Filter") final Filter filter)
	{
		if (name == null)
		{
			LOGGER.error("No name provided for MyCustomAppenderImpl");
			return null;
		}
		if (layout == null)
		{
			layout = PatternLayout.createDefaultLayout();
		}
		return new NaMaPerSessionLogAppender(name, filter, layout);
	}

	@Override
	public void append(LogEvent event)
	{
		for (ThreadLocalLogger logger : NaMaPerSessionLogUtil.getLoggers().values())
		{
			if (logger.shouldLog())
				logger.log(new String(getLayout().toByteArray(event), StandardCharsets.UTF_8));
		}
	}
}
