package com.namasoft.common.utils;

import java.io.InputStream;
import java.util.Properties;

import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.constants.SettingsIDs;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;

public class ReplicationSiteSettings
{
	private static Properties properties = null;
	private static Byte siteSequence = null;

	public static synchronized void reset()
	{
		properties = null;
		siteSequence = null;
	}

	public static synchronized Properties load()
	{
		if (properties == null)
		{
			properties = new Properties();
			try
			{
				InputStream settingStream = GeneralSettings.class.getClassLoader().getResourceAsStream(SettingsIDs.REPLICATION_FILE_NAME);
				if (settingStream == null)
					return properties;
				properties.load(settingStream);
				settingStream.close();
			}
			catch (Throwable e)
			{
				NaMaLogger.info("Could not read settings", e);
			}
		}
		return properties;
	}

	public static String getReplicationSite()
	{
		return ObjectChecker.getFirstNotEmptyObj(load().getProperty(SettingsIDs.REPLICATION_SITE_ID), "").trim();
	}

	public static String getHeadOfficeAddresses()
	{
		return ObjectChecker.getFirstNotEmptyObj(load().getProperty(SettingsIDs.HEAD_OFFICE_URL, ""),
				load().getProperty(SettingsIDs.HEAD_OFFICE_IP, ""));
	}

	public static boolean isReplicationEnabled()
	{
		return ObjectChecker.isTrue(ObjectChecker.valueOfBoolean(load().getProperty(SettingsIDs.REPLICATION_EANBLED)));
	}

	public static boolean isReplicationSupported()
	{
		return ObjectChecker.isTrue(ObjectChecker.valueOfBoolean(load().getProperty(SettingsIDs.REPLICATION_SUPPORTED)));
	}

	public static boolean isHeadOffice()
	{
		return isHeadOffice(getReplicationSite());
	}

	public static boolean isHeadOffice(String replicationSite)
	{
		return ObjectChecker.areEqual(replicationSite, CommonConstants.HEAD_OFFICE);
	}

	public static boolean isNOTReplicationEnabled()
	{
		return !isReplicationEnabled();
	}

	public static byte getSiteSequence()
	{
		if (siteSequence != null)
			return siteSequence;
		if (isReplicationEnabled())
		{
			String siteId = load().getProperty("sitesequence");
			if (ObjectChecker.isEmptyOrNull(siteId))
				throw new RuntimeException("You must set sitesequence in replication.properties");
			return siteSequence = Byte.valueOf(siteId);
		}
		else
		{
			return siteSequence = 0;
		}
	}

	public static boolean isNotHeadOffice()
	{
		return !isHeadOffice();
	}
}
