package com.namasoft.common.utils;

import com.namasoft.common.constants.TimePeriodType;
import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;
import java.util.*;

public class TimePeriodUtilsNormal
{

	public static Date subtractTimePeriodToDate(Date date, String uom, BigDecimal value)
	{
		if (ObjectChecker.isEmptyOrNull(uom) || ObjectChecker.isEmptyOrZero(value))
			return date;
		return subtractTimePeriodToDate(date, TimePeriodType.valueOf(uom), value);
	}

	public static Date subtractTimePeriodToDate(Date date, TimePeriodType uom, Integer value)
	{
		return TimePeriodUtils.addTimePeriodToDate(date, uom, BigDecimal.valueOf(value), -1, false);
	}

	public static Date subtractTimePeriodToDate(Date date, TimePeriodType uom, BigDecimal value)
	{
		return TimePeriodUtils.addTimePeriodToDate(date, uom, value, -1, false);
	}

	public static Date addTimePeriodToDate(Date date, TimePeriodType uom, BigDecimal value)
	{
		return TimePeriodUtils.addTimePeriodToDate(date, uom, value, 1, false);
	}
}
