package com.namasoft.common.utils.importer.parser;

import java.util.List;

import com.namasoft.common.flatobjects.NaMaError;
import com.namasoft.common.utils.importer.data.Indicator;
import com.namasoft.common.utils.importer.data.DataRecord;
import com.namasoft.common.utils.importer.data.DetailEntryRow;

public interface ImportDataManager
{
	List<String> nextLine();

	int currentLineNumber();

	void markRecordAsInserted(DataRecord dataRecord);

	void markRecordAsError(DataRecord dataRecord, List<NaMaError> errors);

	void finish();

	void addLine(Indicator indicator, String... cells);

	void addLine(Indicator indicator, List<String> cells);

	boolean activateSheet(String id);

	void addSheet(String id);

	boolean moveToNextSheet();

	String currentSheet();

	void markDetailLineAsError(DataRecord dataRecord, String parentID, DetailEntryRow row, NaMaError error);
}
