package com.namasoft.specialserialization;

import com.google.common.io.Files;
import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;

public class CSSColorVariablesExtractor
{

	public static void main(String[] args) throws IOException
	{
		List<Pair<String, String>> variables = Arrays.stream(CSSColorVariablesExtractor.variables.split("\n")).map(s -> s.split(" "))
				.map(a -> new Pair<>(a[1], a[2])).filter(p -> ObjectChecker.NOTisAnyEqualToFirst(p.getX(), "selectionBorderWidth", "lableMinHeight"))
				.collect(Collectors.toList());
		for (Pair<String, String> variable : variables)
		{
			if (variable.getY().toLowerCase().contains("color"))
				variable.setY("var(--" + variable.getY() + ")");
		}
		List<String> cssParts = Files.readLines(
				new File("C:/Users/Ahmed/dev/erp/nama202200/code/infra/gui-base/src/main/java/com/namasoft/erp/gui/base/resources/RTL.css"),
				StandardCharsets.UTF_8);
		StringBuilder allCSS = new StringBuilder();
		allCSS.append(":root {\n");
		variables.stream().map(p -> "--" + p.getX() + ":" + p.getY() + ";\n").forEach(allCSS::append);
		allCSS.append("}\n");
		for (int i = 113; i < cssParts.size(); i++)
		{
			String line = cssParts.get(i);
			if (line.contains("@def"))
				continue;
			if (line.contains("{"))
			{
				StringBuilder subCSS = new StringBuilder();
				subCSS.append(line).append("\n");
				boolean hadParts = false;
				j:
				for (int j = i + 1; j < cssParts.size(); j++)
				{
					String cssPart = cssParts.get(j);
					if (cssPart.contains("/*") || cssPart.contains("*/") || cssPart.contains("-moz-") || cssPart.contains("-ms-") || cssPart.contains(
							"-o-") || cssPart.contains("-khtml-"))
						continue j;
					boolean withVar = false;
					for (Pair<String, String> variable : variables)
					{
						if (cssPart.contains(variable.getX()))
						{
							hadParts = true;
							withVar = true;
							cssPart = cssPart.replace(variable.getX(), "var(--" + variable.getX() + ")");
						}
					}
					if (withVar)
						subCSS.append(cssPart).append("\n");
					if (cssPart.contains("}"))
					{
						subCSS.append(cssPart).append("\n");
						i = j;
						break j;
					}
				}
				if (hadParts)
					allCSS.append(subCSS);
			}
		}
		System.out.println(allCSS.toString().replace(";;", ";"));
	}

	private static final String variables = "@def darkestBackColor #F5F1E6 ;\n" + "@def darkBackColor #FCFAF7 ;\n" + "@def lightBackColor #F8F6EF ;\n"
			+ "@def formOddRowBackColor darkBackColor ;\n" + "@def formEvenRowBackColor lightBackColor ;\n"
			+ "@def groupHeaderBackColor darkestBackColor ;\n" + "@def formBorderColor #DED9C8 ;\n" + "@def formLabelColor #586E75 ;\n"
			+ "@def tabBackColor formOddRowBackColor ;\n" + "@def tabSelectedBackColor groupHeaderBackColor ;\n"
			+ "@def gridHeaderBackColor groupHeaderBackColor ;\n" + "@def tabBorderColor formBorderColor ;\n" + "@def lableMinHeight 2em ;\n"
			+ "@def dialogHeaderBackColor groupHeaderBackColor ;\n" + "@def allBordersColor formBorderColor ;\n"
			+ "@def headerRowBackColor groupHeaderBackColor ;\n" + "@def headerRowColor formLabelColor ;\n"
			+ "@def oddRowBackColor formOddRowBackColor ;\n" + "@def l3RowBackColor #F5F1F0;\n" + "@def evenRowBackColor white ;\n"
			+ "@def selectionBorderWidth 2px ;\n" + "@def majorHeadingColor #183541 ;\n" + "@def gradStartColor1 #B7D8ED;\n"
			+ "@def gradEndColor1 #75A6C8;\n" + "@def gradStartColor2 #B7D8ED;\n" + "@def gradEndColor2 #75A6C8;\n"
			+ "@def gradStartColor3 #B7D8ED;\n" + "@def gradEndColor3 #75A6C8;\n" + "@def gradStartColor4 #F9FBF0 ;\n"
			+ "@def gradEndColor4 #E3EDF0;\n" + "@@def headersColor white;";
}
