package com.namasoft.specialserialization;

import com.namasoft.common.utilities.ObjectCreator;

import java.lang.reflect.*;

public class ObjectCreatorUtil
{
	public static <T> ObjectCreator<T> creator(final String klass)
	{
		try
		{
			return (ObjectCreator<T>) creator(Class.forName(klass));
		}
		catch (ClassNotFoundException e)
		{
			throw new RuntimeException(e);
		}
	}

	public static <T> ObjectCreator<T> creatorForPrivateConstructor(final String klassName)
	{
		try
		{
			Class<?> klass = Class.forName(klassName);
			Constructor<?> constructor = klass.getDeclaredConstructor();
			constructor.setAccessible(true);
			return () -> {
				try
				{
					return (T) constructor.newInstance();
				}
				catch (InstantiationException e)
				{
					throw new RuntimeException(e);
				}
				catch (IllegalAccessException e)
				{
					throw new RuntimeException(e);
				}
				catch (InvocationTargetException e)
				{
					throw new RuntimeException(e);
				}
			};
		}
		catch (ClassNotFoundException | NoSuchMethodException e)
		{
			throw new RuntimeException(e);
		}
	}
	public static <T> ObjectCreator<T> creator(final Class<T> klass)
	{
		return () ->
		{
			try
			{
				return klass.newInstance();
			}
			catch (IllegalAccessException | InstantiationException e)
			{
				throw new RuntimeException(e);
			}
		};
	}
}
