package com.namasoft.taxauthority.jordan;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.taxauthority.ksa.entities.UBLEInvoiceTypeCode;

import jakarta.xml.bind.annotation.*;

@XmlRootElement(name = "Invoice")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class JoFotaraInvoice extends AbsJoFotaraInvoice
{
	public JoFotaraInvoice()
	{
		setInvoiceTypeCode(UBLEInvoiceTypeCode.TAX_INVOICE.getCode());
	}

	@Override
	public String edocumentType()
	{
		if (ObjectChecker.areEqual(JoFotaraInvoiceType.Income, getJoFotaraInvoiceType()))
			return "IncomeInvoice";
		if (ObjectChecker.areEqual(JoFotaraInvoiceType.Public, getJoFotaraInvoiceType()))
			return "PublicInvoice";
		return "PrivateInvoice";
	}

	@Override
	public boolean invoice()
	{
		return true;
	}
}
