package com.namasoft.contracts.common.dtos;

import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.utilities.*;
import com.namasoft.modules.commonbasic.enums.AutoSaveBehavior;

import java.io.Serializable;
import java.util.*;

public class ListOfGenericValues implements Serializable, NamaObject
{
	private static final long serialVersionUID = -3157920779008771975L;
	private List<GenericValue> details = new ArrayList<GenericValue>();
	private List<CallPostActionInfo> callPostActorsForFields = new ArrayList<>();
	private String performGUIAction;
	private String pendingResponseId;
	private Boolean forceCallAutoSave = false;
	private AutoSaveBehavior autoSaveBehavior = AutoSaveBehavior.AlwaysSaveAsDraft;
	private String focusFieldAfterAutoSave;
	private String addLineToGridAfterAutoSave;

	public List<GenericValue> getDetails()
	{
		return details;
	}

	public void setDetails(List<GenericValue> details)
	{
		this.details = details;
	}

	public ListOfGenericValues addValue(GenericValue fieldGenericValue)
	{
		getDetails().add(fieldGenericValue);
		return this;
	}

	public ListOfGenericValues addValueIfNotNull(String fieldId, Object value)
	{
		if (ObjectChecker.isNotEmptyOrNull(value))
			addValue(fieldId, value);
		return this;
	}

	public ListOfGenericValues addValue(String fieldId, Object value)
	{
		getDetails().add(new GenericValue(fieldId, value));
		return this;
	}

	public void updateValuesFrom(ListOfGenericValues from)
	{
		if (ObjectChecker.isEmptyOrNull(from))
			return;
		for (GenericValue value : from.getDetails())
			updateValue(value.getFieldId(), value.calcFieldValue());
	}

	public String getPerformGUIAction()
	{
		return performGUIAction;
	}

	public void setPerformGUIAction(String performGUIAction)
	{
		this.performGUIAction = performGUIAction;
	}

	public String getPendingResponseId()
	{
		return pendingResponseId;
	}

	public void setPendingResponseId(String pendingResponseId)
	{
		if (ObjectChecker.isNotEmptyOrNull(this.pendingResponseId) && ObjectChecker.areNotEqual(pendingResponseId, this.pendingResponseId))
			throw new RuntimeException("Can not reset pendingResponseId");
		this.pendingResponseId = pendingResponseId;
	}

	public Boolean getForceCallAutoSave()
	{
		return forceCallAutoSave;
	}

	public AutoSaveBehavior getAutoSaveBehavior()
	{
		return autoSaveBehavior;
	}

	public void setAutoSaveBehavior(AutoSaveBehavior autoSaveBehavior)
	{
		this.autoSaveBehavior = autoSaveBehavior;
	}

	public String getFocusFieldAfterAutoSave()
	{
		return focusFieldAfterAutoSave;
	}

	public void setFocusFieldAfterAutoSave(String focusFieldAfterAutoSave)
	{
		this.focusFieldAfterAutoSave = focusFieldAfterAutoSave;
	}

	public String getAddLineToGridAfterAutoSave()
	{
		return addLineToGridAfterAutoSave;
	}

	public void setAddLineToGridAfterAutoSave(String addLineToGridAfterAutoSave)
	{
		this.addLineToGridAfterAutoSave = addLineToGridAfterAutoSave;
	}

	public void setForceCallAutoSave(Boolean forceCallAutoSave)
	{
		this.forceCallAutoSave = forceCallAutoSave;
	}

	public void updateValue(String fieldId, Object value)
	{
		for (GenericValue genericValue : getDetails())
		{
			if (ObjectChecker.areEqual(fieldId, genericValue.getFieldId()))
			{
				genericValue.updateFieldValue(value);
				return;
			}
		}
		getDetails().add(new GenericValue(fieldId, value));
	}

	public <T> T findValue(String id)
	{
		for (GenericValue genericValue : getDetails())
		{
			if (ObjectChecker.areEqual(id, genericValue.getFieldId()))
			{
				return (T) genericValue.calcFieldValue();
			}
		}
		return null;
	}

	public GenericValue findGenericValue(String id)
	{
		for (GenericValue genericValue : getDetails())
		{
			if (ObjectChecker.areEqual(id, genericValue.getFieldId()))
			{
				return genericValue;
			}
		}
		return null;
	}

	public void addAllowedValues(String fieldId, List<String> allowedValues)
	{
		getDetails().add(new GenericValue(CommonConstants.ALLOWED_VALUES_PREFIX + fieldId, GenericList.createFromList(allowedValues, null)));
	}

	public void addNulls(String... ids)
	{
		for (String id : ids)
		{
			addValue(id, null);
		}
	}

	public List<CallPostActionInfo> getCallPostActorsForFields()
	{
		return callPostActorsForFields;
	}

	public void setCallPostActorsForFields(List<CallPostActionInfo> callPostActorsForFields)
	{
		this.callPostActorsForFields = callPostActorsForFields;
	}

	public ListOfGenericValues addCalledPostActor(String id, int row)
	{
		getCallPostActorsForFields().add(new CallPostActionInfo(id, row));
		return this;
	}

	public ListOfGenericValues addCalledPostActor(String id)
	{
		getCallPostActorsForFields().add(new CallPostActionInfo(id));
		return this;
	}

	public void setIfCurrentEmpty(String id, Object currentValue, Object newValue)
	{
		if (ObjectChecker.isEmptyOrNull(currentValue))
			addValue(id, newValue);
	}

	public void addAll(List<GenericValue> newValues)
	{
		getDetails().addAll(newValues);
	}

	public void addSlaveFields(String detailId, String masterLineId, FlatObjectList slaves)
	{
		addValue(CommonFieldIds.SLAVE_ROWS + CommonConstants.HOPEFULLY_UNIQUE_FIELD_SEP + detailId + CommonConstants.HOPEFULLY_UNIQUE_FIELD_SEP
				+ masterLineId, slaves);
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getDetails(), getCallPostActorsForFields(), getPerformGUIAction());
	}

	public void remove(String id)
	{

		for (int i = getDetails().size() - 1; i >= 0; i--)
		{
			GenericValue genericValue = getDetails().get(i);
			if (ObjectChecker.areEqual(id, genericValue.getFieldId()))
			{
				getDetails().remove(i);
			}
		}
	}

	public GUIActionResult addTo(GUIActionResult result)
	{
		result.setType(GUIActionResultType.UpdateList);
		result.getUpdateList().addAll(getDetails());
		return result;
	}

	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		for (GenericValue value : getDetails())
		{
			builder.append("-- " + value + "\n");
		}
		return builder.toString();
	}

	public ListOfGenericValues performGUIAction(String actionId)
	{
		setPerformGUIAction(actionId);
		return this;
	}
}
