package com.namasoft.contracts.common.dtos;

import java.io.Serializable;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.layout.metadata.EntityTypeMetaData;
import com.namasoft.common.layout.metadata.ModuleEntitiesMetaData;
import com.namasoft.common.utilities.ObjectChecker;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ModuleDescription implements Serializable, Comparable<ModuleDescription>
{
	private static final long serialVersionUID = -5147002325938215772L;

	private ModuleAddress moduleAddress;
	private ModuleEntitiesMetaData entitiesMetaData;
	private List<String> definedFeatures;
	private List<String> embededModules;

	public ModuleDescription()
	{
	}

	public ModuleDescription(ModuleAddress moduleAddress2, ModuleEntitiesMetaData entitiesMetaData, List<String> definedFeatures,
			List<String> embededModules)
	{
		this.moduleAddress = moduleAddress2;
		this.entitiesMetaData = entitiesMetaData;
		this.definedFeatures = definedFeatures;
		this.embededModules = embededModules;
	}

	public ModuleEntitiesMetaData getEntitiesMetaData()
	{
		return entitiesMetaData;
	}

	public void setEntitiesMetaData(ModuleEntitiesMetaData entitiesMetaData)
	{
		this.entitiesMetaData = entitiesMetaData;
	}

	public ModuleAddress getModuleAddress()
	{
		return moduleAddress;
	}

	public void setModuleAddress(ModuleAddress moduleAddress)
	{
		this.moduleAddress = moduleAddress;
	}

	@XmlTransient
	public String getModuleId()
	{
		return getEntitiesMetaData().getModuleId();
	}

	public EntityTypeMetaData getEntityMetaData(String entityType)
	{
		return getEntitiesMetaData().getEntity(entityType);
	}

	@Override
	public String toString()
	{
		return getModuleId() + ":" + getModuleAddress();
	}

	public List<String> getDefinedFeatures()
	{
		return definedFeatures;
	}

	public void setDefinedFeatures(List<String> definedFeatures)
	{
		this.definedFeatures = definedFeatures;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof ModuleDescription))
			return super.equals(obj);
		return ObjectChecker.areEqual(getModuleId(), ((ModuleDescription) obj).getModuleId());
	}

	@Override
	public int hashCode()
	{
		return getModuleId() == null ? super.hashCode() : getModuleId().hashCode();
	}

	@Override
	public int compareTo(ModuleDescription o)
	{
		return getModuleId().compareTo(o.getModuleId());
	}

	public List<String> getEmbededModules()
	{
		return embededModules;
	}

	public void setEmbededModules(List<String> embededModules)
	{
		this.embededModules = embededModules;
	}

}
