package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.*;

import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class AGGridGetRowsRequest
{
	// First row requested or undefined for all rows.
	private Integer startRow;
	// Index after the last row required row or undefined for all rows.
	private Integer endRow;
	// Columns that are currently row grouped.
	private List<AGGridColumnVO> rowGroupCols;
	// Columns that have aggregations on them.
	private List<AGGridColumnVO> valueCols;
	// Columns that have pivot on them.
	private List<AGGridColumnVO> pivotCols;
	// Defines if pivot mode is on or off.
	private boolean pivotMode;
	// What groups the user is viewing.
	private List<String> groupKeys;
	// If filtering, what the filter model is.
	// If Advanced Filter is enabled, will be of type `AdvancedFilterModel | null`.
	// If Advanced Filter is disabled, will be of type `FilterModel`.
	private Map<String, AGGridProvidedFilterModel> filterModel;
	// If sorting, what the sort model is.
	private List<AGGridSortModelItem> sortModel;
	private Boolean forTimeline;
	private Integer page;
	private Integer pageSize;
	private Boolean showLoadingIndicator;

	public AGGridGetRowsRequest()
	{
	}

	public Integer getStartRow()
	{
		return startRow;
	}

	public void setStartRow(Integer startRow)
	{
		this.startRow = startRow;
	}

	public Integer getEndRow()
	{
		return endRow;
	}

	public void setEndRow(Integer endRow)
	{
		this.endRow = endRow;
	}

	public List<AGGridColumnVO> getRowGroupCols()
	{
		return rowGroupCols;
	}

	public void setRowGroupCols(List<AGGridColumnVO> rowGroupCols)
	{
		this.rowGroupCols = rowGroupCols;
	}

	public List<AGGridColumnVO> getValueCols()
	{
		return valueCols;
	}

	public void setValueCols(List<AGGridColumnVO> valueCols)
	{
		this.valueCols = valueCols;
	}

	public List<AGGridColumnVO> getPivotCols()
	{
		return pivotCols;
	}

	public void setPivotCols(List<AGGridColumnVO> pivotCols)
	{
		this.pivotCols = pivotCols;
	}

	public boolean isPivotMode()
	{
		return pivotMode;
	}

	public void setPivotMode(boolean pivotMode)
	{
		this.pivotMode = pivotMode;
	}

	public List<String> getGroupKeys()
	{
		return groupKeys;
	}

	public void setGroupKeys(List<String> groupKeys)
	{
		this.groupKeys = groupKeys;
	}

	public Map<String, AGGridProvidedFilterModel> getFilterModel()
	{
		return filterModel;
	}

	public void setFilterModel(Map<String, AGGridProvidedFilterModel> filterModel)
	{
		this.filterModel = filterModel;
	}

	public List<AGGridSortModelItem> getSortModel()
	{
		return sortModel;
	}

	public void setSortModel(List<AGGridSortModelItem> sortModel)
	{
		this.sortModel = sortModel;
	}

	public Boolean getForTimeline()
	{
		return forTimeline;
	}

	public void setForTimeline(Boolean forTimeline)
	{
		this.forTimeline = forTimeline;
	}

	public Integer getPage()
	{
		return page;
	}

	public void setPage(Integer page)
	{
		this.page = page;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
	}

	public Boolean getShowLoadingIndicator()
	{
		return showLoadingIndicator;
	}

	public void setShowLoadingIndicator(Boolean showLoadingIndicator)
	{
		this.showLoadingIndicator = showLoadingIndicator;
	}
}
