package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.*;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TransientCodeRequest extends EntityServiceRequest
{
	private EntityReferenceData autoCoder;
	private FlatObject currentEntity;

	public TransientCodeRequest()
	{
	}

	public TransientCodeRequest(String entityType, EntityReferenceData autoCoder, FlatObject currentEntity)
	{
		super(entityType);
		this.currentEntity = currentEntity;
		this.autoCoder = autoCoder;
	}

	public EntityReferenceData getAutoCoder()
	{
		return autoCoder;
	}

	public void setAutoCoder(EntityReferenceData autoCoder)
	{
		this.autoCoder = autoCoder;
	}

	public FlatObject getCurrentEntity()
	{
		return currentEntity;
	}

	public void setCurrentEntity(FlatObject currentEntity)
	{
		this.currentEntity = currentEntity;
	}
}
