package com.namasoft.contracts.common.dtos.results;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.constants.OutputFormat;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTORunReportResult extends ServiceResponse
{
	private OutputFormat format;
	private String outputName;
	// private DataHandler output;
	private String tempPrintId;
	private String printerName;
	private String outputPath;
	// private Long outputLength;
	private List<DTORunReportResult> relatedResults;
	private boolean emptyReport;
	private String taskId;
	private boolean processed = true;
	private int currentPagesCount;

	public DTORunReportResult(ResultDTO result)
	{
		super(result);
	}

	public DTORunReportResult()
	{
		super();
	}

	public OutputFormat getFormat()
	{
		return format;
	}

	public void setFormat(OutputFormat format)
	{
		this.format = format;
	}

	public String getOutputName()
	{
		return outputName;
	}

	public void setOutputName(String outputName)
	{
		this.outputName = outputName;
	}

	// public DataHandler getOutput()
	// {
	// return output;
	// }
	//
	// public void setOutput(DataHandler output)
	// {
	// this.output = output;
	// }

	public String getPrinterName()
	{
		return printerName;
	}

	public void setPrinterName(String printerName)
	{
		this.printerName = printerName;
	}

	public String getTempPrintId()
	{
		return tempPrintId;
	}

	public void setTempPrintId(String tempPrintId)
	{
		this.tempPrintId = tempPrintId;
	}

	// public Long getOutputLength()
	// {
	// return outputLength;
	// }
	//
	// public void setOutputLength(Long outputLength)
	// {
	// this.outputLength = outputLength;
	// }

	public List<DTORunReportResult> getRelatedResults()
	{
		return relatedResults;
	}

	public void setRelatedResults(List<DTORunReportResult> relatedResults)
	{
		this.relatedResults = relatedResults;
	}

	public void addRelatedTempPrint(DTORunReportResult relatedReportResult)
	{
		if (getRelatedResults() == null)
			setRelatedResults(new ArrayList<DTORunReportResult>());
		getRelatedResults().add(relatedReportResult);
	}

	public boolean isEmptyReport()
	{
		return emptyReport;
	}

	public void setEmptyReport(boolean emptyReport)
	{
		this.emptyReport = emptyReport;
	}

	public String getOutputPath()
	{
		return outputPath;
	}

	public void setOutputPath(String outputPath)
	{
		this.outputPath = outputPath;
	}

	public String getTaskId()
	{
		return taskId;
	}

	public void setTaskId(String taskId)
	{
		this.taskId = taskId;
	}

	public boolean isProcessed()
	{
		return processed;
	}

	public void setProcessed(boolean processed)
	{
		this.processed = processed;
	}

	public int getCurrentPagesCount()
	{
		return currentPagesCount;
	}

	public void setCurrentPagesCount(int currentPagesCount)
	{
		this.currentPagesCount = currentPagesCount;
	}
}
