package com.namasoft.contracts.common.services;

import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.utils.dm.pojo.*;
import com.namasoft.contracts.common.dtos.*;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.infra.contractsbase.common.approval.DTOApprovalCase;
import com.namasoft.modules.commonbasic.contracts.entities.DTOCustomer;
import com.namasoft.modules.commonbasic.contracts.valueobjects.*;
import com.namasoft.specialserialization.ReportDetailsResponse;

import jakarta.jws.*;

@WebService(name = "coreutilitiesws")
public interface CoreUtilitiesWS
{
	@WebMethod
	GetResult<TarnsientCode> createTransientCode(@WebParam(name = "request") TransientCodeRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<CalculatedFiscalYearAndPeriod> calcaulateFiscalPeriodAndYear(@WebParam(name = "request") CalcFiscalPeriodAndYearRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getRoutedModuleForEntityById(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getRoutedModuleForEntityByBusinessCode(@WebParam(name = "request") FindByBusinessCodeRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getRoutedModuleForEntityByNavigation(@WebParam(name = "request") NavigationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse reindexAll(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> importReports(@WebParam(name = "request") SendRequest<DTOLargeData> source) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOLargeData> exportReports(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFieldFilteringParamsRes> getFieldsDimsFiltering(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse runScheduledTask(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOUserEmailReceiverSettings> fetchUserMailAndPassword(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOUserDashboardResponse> fetchUserDashboardCharts(@WebParam(name = "request") ChartFetcherRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<ReportMetadata> fetchUserDashboardMetadata(ChartFetcherRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> fetchUserEmployee(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Integer> fetchCurrentUserMaxExportCount(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<GUIActionResult> runCustomAction(@WebParam(name = "request") SendRequest<PerformActionReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> evalImportValue(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cancelActivated(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> handleIntegrator(SendRequest<IntegratorRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> handleReadIntegrator(SendRequest<IntegratorRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> changePassword(@WebParam(name = "changePasswordRequest") ChangePasswordRequest changePasswordRequest)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateNotificationsToRead(@WebParam(name = "rquestCommit") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetPasswordByMailOrSMS(@WebParam(name = "changePasswordRequest") ResetPasswordRequest resorePasswordRequest)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> resendOtpMsg(@WebParam(name = "resendOtpMsg") ResendOtpRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetPasswordByToken(@WebParam(name = "resetPasswordByTokenRequest") ResetPasswordByTokenRequest resetPasswordByTokenRequest)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse addDiscussion(@WebParam(name = "request") SendRequest<DTODiscussionRecord> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse revokeApprovalRequest(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse sendEmailWithReportResult(@WebParam(name = "request") SendRequest<DTOEmailSendRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOApprovalCase> findApprovalCaseById(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOAutoDashboardsAndReports> fetchAutoDashboardAndReportGroups(@WebParam(name = "request") ServiceRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOUserDashboardResponse> fetchUserDashboardMobileCharts(@WebParam(name = "request") MobileChartFetcherRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	MapResult<String, String> getTermConfigDTOClasses(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> isTreatedAsAdmin(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> nlmAction(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> nlmActionNoAuth(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOGenericDimensions> findPublicDimensions(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOHelpMessagesResponse> fetchHelpsForFieldOrErrorMsg(@WebParam(name = "request") SendRequest<DTOHelpMessagesRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFieldsHelpMessagesResponse> fetchHelpMsgsForFields(@WebParam(name = "request") SendRequest<DTOHelpMessagesForFieldsRequest> request)
			throws NaMaServiceExcepption;

	GetResult<DTOImportIntegratorResponse> findImportIntegrator(SendRequest<IntegratorRequest> request);

	@WebMethod
	GetResult<DTOCustomer> updateCustomerCalculatedFields(@WebParam(name = "request") SendRequest<DTOCustomerUpdaterRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse refreshLicence(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> exportRecordsAsJson(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<FlatObject> callUpdateCalculatedFields(@WebParam(name = "request") SendRequest<FlatObject> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTONamaRewardInfo> calculateRemainingRewardInfo(@WebParam(name = "request") SendRequest<DTORewardPointsInfo> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DMPersister> fetchDataModels(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DMEntity> appendDSPropertiesToDMEntity(@WebParam(name = "request") SendRequest<DSPropsToDMEntityReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<SuggestionList> suggestMainEntity(@WebParam(name = "request") SendRequest<SuggestMainEntityReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ReportDetailsResponse> fetchReportDetails(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> findInvoiceEntitiesWithMoneyObject(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> getQueryColumnNames(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EntityReferenceData> fetchCurrentUserAsRef(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;
}
