package com.namasoft.infra.contractsbase.common.approval;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOTimePeriod;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOApprovalCriticalField;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTONotificationTemplates;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOApprovalDefinition extends MasterFileDTO implements Serializable
{
	private Boolean allowEditAfterUsage;
	private Boolean allowModifyWhileUnderApproval;
	private Boolean analysisSetMustMatchRecord;
	private Boolean approveLines;
	private Boolean branchMustMatchRecord;
	private Boolean commentRequired;
	private Boolean confirmBeforeStarting;
	private Boolean considerRequestDateAsCreationDate;
	private Boolean convertRequestAfterApproval;
	private Boolean departmentMustMatchRecord;
	private Boolean doNotSendToFCM;
	private Boolean flushBeforeSummary;
	private Boolean ignoreUsageCapabilityOnAppr;
	private Boolean inActive;
	private Boolean legalEntityMustMatchRecord;
	private Boolean onRejectLineDelete;
	private Boolean reqCommentInApprovalLinks;
	private Boolean requireExecution;
	private Boolean requireOtpForAllSteps;
	private Boolean reviseOnCompletion;
	private Boolean sectorMustMatchRecord;
	private Boolean useWithBudgetExceeded;
	private Boolean useWithDelete;
	private Boolean useWithInsert;
	private Boolean useWithUpdate;
	private DTONotificationTemplates templates;
	private DTOTimePeriod autoEscalateAfter;
	private EntityReferenceData alternate;
	private EntityReferenceData applyAlsoTo;
	private EntityReferenceData criteriaDefinition;
	private EntityReferenceData emailTemplate;
	private EntityReferenceData fallBack;
	private EntityReferenceData notificationTemplate;
	private EntityReferenceData otherAlternates;
	private EntityReferenceData smsTemplate;
	private List<DTOApprovalCriticalField> criticalFields = new ArrayList<DTOApprovalCriticalField>();
	private List<DTOApprovalDefInputFields> inputs = new ArrayList<DTOApprovalDefInputFields>();
	private List<DTOApprovalDefinitionStep> steps = new ArrayList<DTOApprovalDefinitionStep>();
	private List<DTOApprovalRuleLine> rules = new ArrayList<DTOApprovalRuleLine>();
	private List<DTOApprovalStepResponsible> stepRespnsible = new ArrayList<DTOApprovalStepResponsible>();
	private List<DTOStepResponsibleSelector> selectors = new ArrayList<DTOStepResponsibleSelector>();
	private Long priority;
	private String applyWhenQuery;
	private String approvalEmailSubject;
	private String approvalEntity;
	private String approvalRef1Source;
	private String approvalRef2Source;
	private String arabicConfirmation;
	private String englishConfirmation;
	private String fcmNotificationBodyTemplate;
	private String fcmNotificationTitleTemplate;
	private String modifyWhileUnderApprovalPolicy;
	private String summaryQuery;
	private String summaryTemplate;
	public Boolean getAllowEditAfterUsage()
	{
		return allowEditAfterUsage;
	}

	public Boolean getAllowModifyWhileUnderApproval()
	{
		return allowModifyWhileUnderApproval;
	}

	public Boolean getAnalysisSetMustMatchRecord()
	{
		return analysisSetMustMatchRecord;
	}

	public Boolean getApproveLines()
	{
		return approveLines;
	}

	public Boolean getBranchMustMatchRecord()
	{
		return branchMustMatchRecord;
	}

	public Boolean getCommentRequired()
	{
		return commentRequired;
	}

	public Boolean getConfirmBeforeStarting()
	{
		return confirmBeforeStarting;
	}

	public Boolean getConsiderRequestDateAsCreationDate()
	{
		return considerRequestDateAsCreationDate;
	}

	public Boolean getConvertRequestAfterApproval()
	{
		return convertRequestAfterApproval;
	}

	public Boolean getDepartmentMustMatchRecord()
	{
		return departmentMustMatchRecord;
	}

	public Boolean getDoNotSendToFCM()
	{
		return doNotSendToFCM;
	}

	public Boolean getFlushBeforeSummary()
	{
		return flushBeforeSummary;
	}

	public Boolean getIgnoreUsageCapabilityOnAppr()
	{
		return ignoreUsageCapabilityOnAppr;
	}

	public Boolean getInActive()
	{
		return inActive;
	}

	public Boolean getLegalEntityMustMatchRecord()
	{
		return legalEntityMustMatchRecord;
	}

	public Boolean getOnRejectLineDelete()
	{
		return onRejectLineDelete;
	}

	public Boolean getReqCommentInApprovalLinks()
	{
		return reqCommentInApprovalLinks;
	}

	public Boolean getRequireExecution()
	{
		return requireExecution;
	}

	public Boolean getRequireOtpForAllSteps()
	{
		return requireOtpForAllSteps;
	}

	public Boolean getReviseOnCompletion()
	{
		return reviseOnCompletion;
	}

	public Boolean getSectorMustMatchRecord()
	{
		return sectorMustMatchRecord;
	}

	public Boolean getUseWithBudgetExceeded()
	{
		return useWithBudgetExceeded;
	}

	public Boolean getUseWithDelete()
	{
		return useWithDelete;
	}

	public Boolean getUseWithInsert()
	{
		return useWithInsert;
	}

	public Boolean getUseWithUpdate()
	{
		return useWithUpdate;
	}

	public DTONotificationTemplates getTemplates()
	{
		return templates;
	}

	public DTOTimePeriod getAutoEscalateAfter()
	{
		return autoEscalateAfter;
	}

	public EntityReferenceData getAlternate()
	{
		return alternate;
	}

	public EntityReferenceData getApplyAlsoTo()
	{
		return applyAlsoTo;
	}

	public EntityReferenceData getCriteriaDefinition()
	{
		return criteriaDefinition;
	}

	public EntityReferenceData getEmailTemplate()
	{
		return emailTemplate;
	}

	public EntityReferenceData getFallBack()
	{
		return fallBack;
	}

	public EntityReferenceData getNotificationTemplate()
	{
		return notificationTemplate;
	}

	public EntityReferenceData getOtherAlternates()
	{
		return otherAlternates;
	}

	public EntityReferenceData getSmsTemplate()
	{
		return smsTemplate;
	}

	public List<DTOApprovalCriticalField> getCriticalFields()
	{
		return criticalFields;
	}

	public List<DTOApprovalDefInputFields> getInputs()
	{
		return inputs;
	}

	public List<DTOApprovalDefinitionStep> getSteps()
	{
		return steps;
	}

	public List<DTOApprovalRuleLine> getRules()
	{
		return rules;
	}

	public List<DTOApprovalStepResponsible> getStepRespnsible()
	{
		return stepRespnsible;
	}

	public List<DTOStepResponsibleSelector> getSelectors()
	{
		return selectors;
	}

	public Long getPriority()
	{
		return priority;
	}

	public String getApplyWhenQuery()
	{
		return applyWhenQuery;
	}

	public String getApprovalEmailSubject()
	{
		return approvalEmailSubject;
	}

	public String getApprovalEntity()
	{
		return approvalEntity;
	}

	public String getApprovalRef1Source()
	{
		return approvalRef1Source;
	}

	public String getApprovalRef2Source()
	{
		return approvalRef2Source;
	}

	public String getArabicConfirmation()
	{
		return arabicConfirmation;
	}

	public String getEnglishConfirmation()
	{
		return englishConfirmation;
	}

	public String getFcmNotificationBodyTemplate()
	{
		return fcmNotificationBodyTemplate;
	}

	public String getFcmNotificationTitleTemplate()
	{
		return fcmNotificationTitleTemplate;
	}

	public String getModifyWhileUnderApprovalPolicy()
	{
		return modifyWhileUnderApprovalPolicy;
	}

	public String getSummaryQuery()
	{
		return summaryQuery;
	}

	public String getSummaryTemplate()
	{
		return summaryTemplate;
	}

	public void setAllowEditAfterUsage(Boolean allowEditAfterUsage)
	{
		this.allowEditAfterUsage = allowEditAfterUsage;
	}

	public void setAllowModifyWhileUnderApproval(Boolean allowModifyWhileUnderApproval)
	{
		this.allowModifyWhileUnderApproval = allowModifyWhileUnderApproval;
	}

	public void setAlternate(EntityReferenceData alternate)
	{
		this.alternate = alternate;
	}

	public void setAnalysisSetMustMatchRecord(Boolean analysisSetMustMatchRecord)
	{
		this.analysisSetMustMatchRecord = analysisSetMustMatchRecord;
	}

	public void setApplyAlsoTo(EntityReferenceData applyAlsoTo)
	{
		this.applyAlsoTo = applyAlsoTo;
	}

	public void setApplyWhenQuery(String applyWhenQuery)
	{
		this.applyWhenQuery = applyWhenQuery;
	}

	public void setApprovalEmailSubject(String approvalEmailSubject)
	{
		this.approvalEmailSubject = approvalEmailSubject;
	}

	public void setApprovalEntity(String approvalEntity)
	{
		this.approvalEntity = approvalEntity;
	}

	public void setApprovalRef1Source(String approvalRef1Source)
	{
		this.approvalRef1Source = approvalRef1Source;
	}

	public void setApprovalRef2Source(String approvalRef2Source)
	{
		this.approvalRef2Source = approvalRef2Source;
	}

	public void setApproveLines(Boolean approveLines)
	{
		this.approveLines = approveLines;
	}

	public void setArabicConfirmation(String arabicConfirmation)
	{
		this.arabicConfirmation = arabicConfirmation;
	}

	public void setAutoEscalateAfter(DTOTimePeriod autoEscalateAfter)
	{
		this.autoEscalateAfter = autoEscalateAfter;
	}

	public void setBranchMustMatchRecord(Boolean branchMustMatchRecord)
	{
		this.branchMustMatchRecord = branchMustMatchRecord;
	}

	public void setCommentRequired(Boolean commentRequired)
	{
		this.commentRequired = commentRequired;
	}

	public void setConfirmBeforeStarting(Boolean confirmBeforeStarting)
	{
		this.confirmBeforeStarting = confirmBeforeStarting;
	}

	public void setConsiderRequestDateAsCreationDate(Boolean considerRequestDateAsCreationDate)
	{
		this.considerRequestDateAsCreationDate = considerRequestDateAsCreationDate;
	}

	public void setConvertRequestAfterApproval(Boolean convertRequestAfterApproval)
	{
		this.convertRequestAfterApproval = convertRequestAfterApproval;
	}

	public void setCriteriaDefinition(EntityReferenceData criteriaDefinition)
	{
		this.criteriaDefinition = criteriaDefinition;
	}

	public void setCriticalFields(List<DTOApprovalCriticalField> criticalFields)
	{
		this.criticalFields = criticalFields;
	}

	public void setDepartmentMustMatchRecord(Boolean departmentMustMatchRecord)
	{
		this.departmentMustMatchRecord = departmentMustMatchRecord;
	}

	public void setDoNotSendToFCM(Boolean doNotSendToFCM)
	{
		this.doNotSendToFCM = doNotSendToFCM;
	}

	public void setEmailTemplate(EntityReferenceData emailTemplate)
	{
		this.emailTemplate = emailTemplate;
	}

	public void setEnglishConfirmation(String englishConfirmation)
	{
		this.englishConfirmation = englishConfirmation;
	}

	public void setFallBack(EntityReferenceData fallBack)
	{
		this.fallBack = fallBack;
	}

	public void setFcmNotificationBodyTemplate(String fcmNotificationBodyTemplate)
	{
		this.fcmNotificationBodyTemplate = fcmNotificationBodyTemplate;
	}

	public void setFcmNotificationTitleTemplate(String fcmNotificationTitleTemplate)
	{
		this.fcmNotificationTitleTemplate = fcmNotificationTitleTemplate;
	}

	public void setFlushBeforeSummary(Boolean flushBeforeSummary)
	{
		this.flushBeforeSummary = flushBeforeSummary;
	}

	public void setIgnoreUsageCapabilityOnAppr(Boolean ignoreUsageCapabilityOnAppr)
	{
		this.ignoreUsageCapabilityOnAppr = ignoreUsageCapabilityOnAppr;
	}

	public void setInActive(Boolean inActive)
	{
		this.inActive = inActive;
	}

	public void setInputs(List<DTOApprovalDefInputFields> inputs)
	{
		this.inputs = inputs;
	}

	public void setLegalEntityMustMatchRecord(Boolean legalEntityMustMatchRecord)
	{
		this.legalEntityMustMatchRecord = legalEntityMustMatchRecord;
	}

	public void setModifyWhileUnderApprovalPolicy(String modifyWhileUnderApprovalPolicy)
	{
		this.modifyWhileUnderApprovalPolicy = modifyWhileUnderApprovalPolicy;
	}

	public void setNotificationTemplate(EntityReferenceData notificationTemplate)
	{
		this.notificationTemplate = notificationTemplate;
	}

	public void setOnRejectLineDelete(Boolean onRejectLineDelete)
	{
		this.onRejectLineDelete = onRejectLineDelete;
	}

	public void setOtherAlternates(EntityReferenceData otherAlternates)
	{
		this.otherAlternates = otherAlternates;
	}

	public void setPriority(Long priority)
	{
		this.priority = priority;
	}

	public void setReqCommentInApprovalLinks(Boolean reqCommentInApprovalLinks)
	{
		this.reqCommentInApprovalLinks = reqCommentInApprovalLinks;
	}

	public void setRequireExecution(Boolean requireExecution)
	{
		this.requireExecution = requireExecution;
	}

	public void setRequireOtpForAllSteps(Boolean requireOtpForAllSteps)
	{
		this.requireOtpForAllSteps = requireOtpForAllSteps;
	}

	public void setReviseOnCompletion(Boolean reviseOnCompletion)
	{
		this.reviseOnCompletion = reviseOnCompletion;
	}

	public void setRules(List<DTOApprovalRuleLine> rules)
	{
		this.rules = rules;
	}

	public void setSectorMustMatchRecord(Boolean sectorMustMatchRecord)
	{
		this.sectorMustMatchRecord = sectorMustMatchRecord;
	}

	public void setSelectors(List<DTOStepResponsibleSelector> selectors)
	{
		this.selectors = selectors;
	}

	public void setSmsTemplate(EntityReferenceData smsTemplate)
	{
		this.smsTemplate = smsTemplate;
	}

	public void setStepRespnsible(List<DTOApprovalStepResponsible> stepRespnsible)
	{
		this.stepRespnsible = stepRespnsible;
	}

	public void setSteps(List<DTOApprovalDefinitionStep> steps)
	{
		this.steps = steps;
	}

	public void setSummaryQuery(String summaryQuery)
	{
		this.summaryQuery = summaryQuery;
	}

	public void setSummaryTemplate(String summaryTemplate)
	{
		this.summaryTemplate = summaryTemplate;
	}

	public void setTemplates(DTONotificationTemplates templates)
	{
		this.templates = templates;
	}

	public void setUseWithBudgetExceeded(Boolean useWithBudgetExceeded)
	{
		this.useWithBudgetExceeded = useWithBudgetExceeded;
	}

	public void setUseWithDelete(Boolean useWithDelete)
	{
		this.useWithDelete = useWithDelete;
	}

	public void setUseWithInsert(Boolean useWithInsert)
	{
		this.useWithInsert = useWithInsert;
	}

	public void setUseWithUpdate(Boolean useWithUpdate)
	{
		this.useWithUpdate = useWithUpdate;
	}

}
