package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.details.DTOMenuItem;
import com.namasoft.modules.commonbasic.contracts.details.DTOUserFavouritesLine;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOUserFavourites extends GeneratedDTOUserFavourites implements Serializable
{
	public List<DTOMenuItem> itemsOf(String groupCode)
	{
		return getFavouriteItems().stream().filter(ObjectChecker.equalsPredicate(groupCode, DTOUserFavouritesLine::getParentGroupCode))
				.filter(l -> l.getTargetFile() != null).map(DTOUserFavouritesLine::toMenuItem).collect(Collectors.toList());
	}
}
