package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOPaymentMethodFee;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSubsidiaryOwner;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOPaymentMethod extends MasterFileDTO implements Serializable
{
	private BigDecimal fees;
	private BigDecimal feesTaxPercentage;
	private BigDecimal feesValue;
	private Boolean allowEditFeesValueManually;
	private Boolean allowEditingFeesTaxManually;
	private Boolean allowFeeValueAndPercentage;
	private Boolean authorizationNumberRequire;
	private Boolean cashPaymentMethod;
	private Boolean companyPaysExpensesInPayment;
	private Boolean criticalPosPaymentMethod;
	private Boolean customerPaysExpensesInReceipt;
	private Boolean disableActualBalanceInPOS;
	private Boolean doNotAffectRemaining;
	private Boolean doNotUseInPosPayments;
	private Boolean doNotUseInPosReceipts;
	private Boolean expandPaymentMethodEffect;
	private Boolean hideInPOSPayment;
	private Boolean hideInShifts;
	private Boolean mustBeWithFeesPercentInReturn;
	private Boolean requireRewardDiscountCoupon;
	private Boolean resetBalanceWithShiftClose;
	private Boolean reverseFeesTaxDebitAndCredit;
	private DTOSubsidiaryOwner subsidiaryAccounts;
	private Date applyFeesTaxFromDate;
	private Date applyFeesTaxToDate;
	private EntityReferenceData bank;
	private EntityReferenceData bankAccount;
	private EntityReferenceData expenseReverseSide;
	private EntityReferenceData feesAccount;
	private EntityReferenceData feesTaxCredit;
	private EntityReferenceData feesTaxDebit;
	private EntityReferenceData feesValueSide;
	private EntityReferenceData paymentValueDirectSide;
	private EntityReferenceData paymentValueSide;
	private EntityReferenceData rewardPointsConfig;
	private EntityReferenceData shiftDiffCreditSide;
	private EntityReferenceData shiftDiffDebitSide;
	private EntityReferenceData subsidiary;
	private EntityReferenceData taxPlan;
	private List<DTOPaymentMethodFee> feeRanges = new ArrayList<DTOPaymentMethodFee>();
	private String taxAuthorityCode;
	public BigDecimal getFees()
	{
		return fees;
	}

	public BigDecimal getFeesTaxPercentage()
	{
		return feesTaxPercentage;
	}

	public BigDecimal getFeesValue()
	{
		return feesValue;
	}

	public Boolean getAllowEditFeesValueManually()
	{
		return allowEditFeesValueManually;
	}

	public Boolean getAllowEditingFeesTaxManually()
	{
		return allowEditingFeesTaxManually;
	}

	public Boolean getAllowFeeValueAndPercentage()
	{
		return allowFeeValueAndPercentage;
	}

	public Boolean getAuthorizationNumberRequire()
	{
		return authorizationNumberRequire;
	}

	public Boolean getCashPaymentMethod()
	{
		return cashPaymentMethod;
	}

	public Boolean getCompanyPaysExpensesInPayment()
	{
		return companyPaysExpensesInPayment;
	}

	public Boolean getCriticalPosPaymentMethod()
	{
		return criticalPosPaymentMethod;
	}

	public Boolean getCustomerPaysExpensesInReceipt()
	{
		return customerPaysExpensesInReceipt;
	}

	public Boolean getDisableActualBalanceInPOS()
	{
		return disableActualBalanceInPOS;
	}

	public Boolean getDoNotAffectRemaining()
	{
		return doNotAffectRemaining;
	}

	public Boolean getDoNotUseInPosPayments()
	{
		return doNotUseInPosPayments;
	}

	public Boolean getDoNotUseInPosReceipts()
	{
		return doNotUseInPosReceipts;
	}

	public Boolean getExpandPaymentMethodEffect()
	{
		return expandPaymentMethodEffect;
	}

	public Boolean getHideInPOSPayment()
	{
		return hideInPOSPayment;
	}

	public Boolean getHideInShifts()
	{
		return hideInShifts;
	}

	public Boolean getMustBeWithFeesPercentInReturn()
	{
		return mustBeWithFeesPercentInReturn;
	}

	public Boolean getRequireRewardDiscountCoupon()
	{
		return requireRewardDiscountCoupon;
	}

	public Boolean getResetBalanceWithShiftClose()
	{
		return resetBalanceWithShiftClose;
	}

	public Boolean getReverseFeesTaxDebitAndCredit()
	{
		return reverseFeesTaxDebitAndCredit;
	}

	public DTOSubsidiaryOwner getSubsidiaryAccounts()
	{
		return subsidiaryAccounts;
	}

	public Date getApplyFeesTaxFromDate()
	{
		return applyFeesTaxFromDate;
	}

	public Date getApplyFeesTaxToDate()
	{
		return applyFeesTaxToDate;
	}

	public EntityReferenceData getBank()
	{
		return bank;
	}

	public EntityReferenceData getBankAccount()
	{
		return bankAccount;
	}

	public EntityReferenceData getExpenseReverseSide()
	{
		return expenseReverseSide;
	}

	public EntityReferenceData getFeesAccount()
	{
		return feesAccount;
	}

	public EntityReferenceData getFeesTaxCredit()
	{
		return feesTaxCredit;
	}

	public EntityReferenceData getFeesTaxDebit()
	{
		return feesTaxDebit;
	}

	public EntityReferenceData getFeesValueSide()
	{
		return feesValueSide;
	}

	public EntityReferenceData getPaymentValueDirectSide()
	{
		return paymentValueDirectSide;
	}

	public EntityReferenceData getPaymentValueSide()
	{
		return paymentValueSide;
	}

	public EntityReferenceData getRewardPointsConfig()
	{
		return rewardPointsConfig;
	}

	public EntityReferenceData getShiftDiffCreditSide()
	{
		return shiftDiffCreditSide;
	}

	public EntityReferenceData getShiftDiffDebitSide()
	{
		return shiftDiffDebitSide;
	}

	public EntityReferenceData getSubsidiary()
	{
		return subsidiary;
	}

	public EntityReferenceData getTaxPlan()
	{
		return taxPlan;
	}

	public List<DTOPaymentMethodFee> getFeeRanges()
	{
		return feeRanges;
	}

	public String getTaxAuthorityCode()
	{
		return taxAuthorityCode;
	}

	public void setAllowEditFeesValueManually(Boolean allowEditFeesValueManually)
	{
		this.allowEditFeesValueManually = allowEditFeesValueManually;
	}

	public void setAllowEditingFeesTaxManually(Boolean allowEditingFeesTaxManually)
	{
		this.allowEditingFeesTaxManually = allowEditingFeesTaxManually;
	}

	public void setAllowFeeValueAndPercentage(Boolean allowFeeValueAndPercentage)
	{
		this.allowFeeValueAndPercentage = allowFeeValueAndPercentage;
	}

	public void setApplyFeesTaxFromDate(Date applyFeesTaxFromDate)
	{
		this.applyFeesTaxFromDate = applyFeesTaxFromDate;
	}

	public void setApplyFeesTaxToDate(Date applyFeesTaxToDate)
	{
		this.applyFeesTaxToDate = applyFeesTaxToDate;
	}

	public void setAuthorizationNumberRequire(Boolean authorizationNumberRequire)
	{
		this.authorizationNumberRequire = authorizationNumberRequire;
	}

	public void setBank(EntityReferenceData bank)
	{
		this.bank = bank;
	}

	public void setBankAccount(EntityReferenceData bankAccount)
	{
		this.bankAccount = bankAccount;
	}

	public void setCashPaymentMethod(Boolean cashPaymentMethod)
	{
		this.cashPaymentMethod = cashPaymentMethod;
	}

	public void setCompanyPaysExpensesInPayment(Boolean companyPaysExpensesInPayment)
	{
		this.companyPaysExpensesInPayment = companyPaysExpensesInPayment;
	}

	public void setCriticalPosPaymentMethod(Boolean criticalPosPaymentMethod)
	{
		this.criticalPosPaymentMethod = criticalPosPaymentMethod;
	}

	public void setCustomerPaysExpensesInReceipt(Boolean customerPaysExpensesInReceipt)
	{
		this.customerPaysExpensesInReceipt = customerPaysExpensesInReceipt;
	}

	public void setDisableActualBalanceInPOS(Boolean disableActualBalanceInPOS)
	{
		this.disableActualBalanceInPOS = disableActualBalanceInPOS;
	}

	public void setDoNotAffectRemaining(Boolean doNotAffectRemaining)
	{
		this.doNotAffectRemaining = doNotAffectRemaining;
	}

	public void setDoNotUseInPosPayments(Boolean doNotUseInPosPayments)
	{
		this.doNotUseInPosPayments = doNotUseInPosPayments;
	}

	public void setDoNotUseInPosReceipts(Boolean doNotUseInPosReceipts)
	{
		this.doNotUseInPosReceipts = doNotUseInPosReceipts;
	}

	public void setExpandPaymentMethodEffect(Boolean expandPaymentMethodEffect)
	{
		this.expandPaymentMethodEffect = expandPaymentMethodEffect;
	}

	public void setExpenseReverseSide(EntityReferenceData expenseReverseSide)
	{
		this.expenseReverseSide = expenseReverseSide;
	}

	public void setFeeRanges(List<DTOPaymentMethodFee> feeRanges)
	{
		this.feeRanges = feeRanges;
	}

	public void setFees(BigDecimal fees)
	{
		this.fees = fees;
	}

	public void setFeesAccount(EntityReferenceData feesAccount)
	{
		this.feesAccount = feesAccount;
	}

	public void setFeesTaxCredit(EntityReferenceData feesTaxCredit)
	{
		this.feesTaxCredit = feesTaxCredit;
	}

	public void setFeesTaxDebit(EntityReferenceData feesTaxDebit)
	{
		this.feesTaxDebit = feesTaxDebit;
	}

	public void setFeesTaxPercentage(BigDecimal feesTaxPercentage)
	{
		this.feesTaxPercentage = feesTaxPercentage;
	}

	public void setFeesValue(BigDecimal feesValue)
	{
		this.feesValue = feesValue;
	}

	public void setFeesValueSide(EntityReferenceData feesValueSide)
	{
		this.feesValueSide = feesValueSide;
	}

	public void setHideInPOSPayment(Boolean hideInPOSPayment)
	{
		this.hideInPOSPayment = hideInPOSPayment;
	}

	public void setHideInShifts(Boolean hideInShifts)
	{
		this.hideInShifts = hideInShifts;
	}

	public void setMustBeWithFeesPercentInReturn(Boolean mustBeWithFeesPercentInReturn)
	{
		this.mustBeWithFeesPercentInReturn = mustBeWithFeesPercentInReturn;
	}

	public void setPaymentValueDirectSide(EntityReferenceData paymentValueDirectSide)
	{
		this.paymentValueDirectSide = paymentValueDirectSide;
	}

	public void setPaymentValueSide(EntityReferenceData paymentValueSide)
	{
		this.paymentValueSide = paymentValueSide;
	}

	public void setRequireRewardDiscountCoupon(Boolean requireRewardDiscountCoupon)
	{
		this.requireRewardDiscountCoupon = requireRewardDiscountCoupon;
	}

	public void setResetBalanceWithShiftClose(Boolean resetBalanceWithShiftClose)
	{
		this.resetBalanceWithShiftClose = resetBalanceWithShiftClose;
	}

	public void setReverseFeesTaxDebitAndCredit(Boolean reverseFeesTaxDebitAndCredit)
	{
		this.reverseFeesTaxDebitAndCredit = reverseFeesTaxDebitAndCredit;
	}

	public void setRewardPointsConfig(EntityReferenceData rewardPointsConfig)
	{
		this.rewardPointsConfig = rewardPointsConfig;
	}

	public void setShiftDiffCreditSide(EntityReferenceData shiftDiffCreditSide)
	{
		this.shiftDiffCreditSide = shiftDiffCreditSide;
	}

	public void setShiftDiffDebitSide(EntityReferenceData shiftDiffDebitSide)
	{
		this.shiftDiffDebitSide = shiftDiffDebitSide;
	}

	public void setSubsidiary(EntityReferenceData subsidiary)
	{
		this.subsidiary = subsidiary;
	}

	public void setSubsidiaryAccounts(DTOSubsidiaryOwner subsidiaryAccounts)
	{
		this.subsidiaryAccounts = subsidiaryAccounts;
	}

	public void setTaxAuthorityCode(String taxAuthorityCode)
	{
		this.taxAuthorityCode = taxAuthorityCode;
	}

	public void setTaxPlan(EntityReferenceData taxPlan)
	{
		this.taxPlan = taxPlan;
	}

}
