package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOLegalEntityTax;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSubsidiaryOwner;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOTaxPlan extends MasterFileDTO implements Serializable
{
	private Boolean itemPlan;
	private Boolean noInvoiceTaxesWithThisPolicy;
	private Boolean noItemTaxesWithThisPolicy;
	private Boolean priorityPolicyOverCusOrSup;
	private DTOSubsidiaryOwner subsidiaryAccounts;
	private DTOTaxConfiguration taxConfiguration;
	private List<DTOLegalEntityTax> legalEntityTaxes = new ArrayList<DTOLegalEntityTax>();
	private String defaultTaxConfig;
	public Boolean getItemPlan()
	{
		return itemPlan;
	}

	public Boolean getNoInvoiceTaxesWithThisPolicy()
	{
		return noInvoiceTaxesWithThisPolicy;
	}

	public Boolean getNoItemTaxesWithThisPolicy()
	{
		return noItemTaxesWithThisPolicy;
	}

	public Boolean getPriorityPolicyOverCusOrSup()
	{
		return priorityPolicyOverCusOrSup;
	}

	public DTOSubsidiaryOwner getSubsidiaryAccounts()
	{
		return subsidiaryAccounts;
	}

	public DTOTaxConfiguration getTaxConfiguration()
	{
		return taxConfiguration;
	}

	public List<DTOLegalEntityTax> getLegalEntityTaxes()
	{
		return legalEntityTaxes;
	}

	public String getDefaultTaxConfig()
	{
		return defaultTaxConfig;
	}

	public void setDefaultTaxConfig(String defaultTaxConfig)
	{
		this.defaultTaxConfig = defaultTaxConfig;
	}

	public void setItemPlan(Boolean itemPlan)
	{
		this.itemPlan = itemPlan;
	}

	public void setLegalEntityTaxes(List<DTOLegalEntityTax> legalEntityTaxes)
	{
		this.legalEntityTaxes = legalEntityTaxes;
	}

	public void setNoInvoiceTaxesWithThisPolicy(Boolean noInvoiceTaxesWithThisPolicy)
	{
		this.noInvoiceTaxesWithThisPolicy = noInvoiceTaxesWithThisPolicy;
	}

	public void setNoItemTaxesWithThisPolicy(Boolean noItemTaxesWithThisPolicy)
	{
		this.noItemTaxesWithThisPolicy = noItemTaxesWithThisPolicy;
	}

	public void setPriorityPolicyOverCusOrSup(Boolean priorityPolicyOverCusOrSup)
	{
		this.priorityPolicyOverCusOrSup = priorityPolicyOverCusOrSup;
	}

	public void setSubsidiaryAccounts(DTOSubsidiaryOwner subsidiaryAccounts)
	{
		this.subsidiaryAccounts = subsidiaryAccounts;
	}

	public void setTaxConfiguration(DTOTaxConfiguration taxConfiguration)
	{
		this.taxConfiguration = taxConfiguration;
	}

}
