package com.namasoft.modules.commonbasic.contracts.requests.inv;

import com.namasoft.common.utilities.*;
import com.namasoft.contracts.common.dtos.config.*;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.regex.Pattern;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOMeasures extends GeneratedDTOMeasures implements Serializable
{
	public static DTOMeasures parseMeasures(String measuresText, DTOGlobalConfig config)
	{
		DTOMeasures measures = new DTOMeasures();
		if (ObjectChecker.isEmptyOrNull(measuresText))
			return measures;
		DTOMeasuresConfiguration measuresConfiguration = config.getMeasuresConfiguration();
		String[] parts = measuresText.split(Pattern.quote(measuresConfiguration.getSeperator()));
		if (parts.length > 0)
			measures.setLength(new BigDecimal(StringUtils.substringAfter(parts[0], measuresConfiguration.getLength())));
		if (parts.length > 1)
			measures.setWidth(new BigDecimal(StringUtils.substringAfter(parts[1], measuresConfiguration.getWidth())));
		if (parts.length > 2)
			measures.setHeight(new BigDecimal(StringUtils.substringAfter(parts[2], measuresConfiguration.getHeight())));
		return measures;
	}

	public BigDecimal fetchClippedHeight1()
	{
		return BigDecimal.ZERO;
	}

	public BigDecimal fetchClippedLength1()
	{
		return getClippedLength1();
	}

	public BigDecimal fetchClippedWidth1()
	{
		return BigDecimal.ZERO;
	}

	public BigDecimal fetchClippedHeight2()
	{
		return BigDecimal.ZERO;
	}

	public BigDecimal fetchClippedLength2()
	{
		return BigDecimal.ZERO;
	}

	public BigDecimal fetchClippedWidth2()
	{
		return BigDecimal.ZERO;
	}
}
