package com.namasoft.modules.commonbasic.contracts.valueobjects;

import jakarta.xml.bind.annotation.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOHandlePaymentRequest
{
	private String configAndEntityKeyEncoded;
	private String jsonDataAsString;
	private String trackId;
	private Boolean failureResponse = false;

	public static DTOHandlePaymentRequest success()
	{
		return new DTOHandlePaymentRequest();
	}

	public static DTOHandlePaymentRequest failure()
	{
		DTOHandlePaymentRequest request = new DTOHandlePaymentRequest();
		request.failureResponse = true;
		return request;
	}

	public String getConfigAndEntityKeyEncoded()
	{
		return configAndEntityKeyEncoded;
	}

	public void setConfigAndEntityKeyEncoded(String configAndEntityKeyEncoded)
	{
		this.configAndEntityKeyEncoded = configAndEntityKeyEncoded;
	}

	public String getJsonDataAsString()
	{
		return jsonDataAsString;
	}

	public void setJsonDataAsString(String urlResponseParameterAsJson)
	{
		this.jsonDataAsString = urlResponseParameterAsJson;
	}

	public String getTrackId()
	{
		return trackId;
	}

	public void setTrackId(String trackId)
	{
		this.trackId = trackId;
	}

	public Boolean getFailureResponse()
	{
		return failureResponse;
	}

	public void setFailureResponse(Boolean failureResponse)
	{
		this.failureResponse = failureResponse;
	}

	public DTOHandlePaymentRequest successInfo()
	{
		this.failureResponse = false;
		return this;
	}

	public DTOHandlePaymentRequest failureInfo()
	{
		this.failureResponse = true;
		return this;
	}
}
