package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTODebtLine extends DTOLocalEntity implements Serializable
{
	private BigDecimal credit;
	private BigDecimal creditLocalAmount;
	private BigDecimal debit;
	private BigDecimal debitLocalAmount;
	private BigDecimal manualValues;
	private BigDecimal remainingCredit;
	private BigDecimal remainingDebit;
	private Boolean fullyMatched;
	private Boolean manuallyFullyMatched;
	private DTOGenericDimensions dimensions;
	private Date originCreationDate;
	private Date valueDate;
	private EntityReferenceData accountRef;
	private EntityReferenceData fiscalPeriod;
	private EntityReferenceData origin;
	private EntityReferenceData subsidiary;
	private String effectType;
	private String entityDimension;
	private String ledgerReqId;
	private String ledgerTransLineId;
	private String searchIndex;
	public BigDecimal getCredit()
	{
		return credit;
	}

	public BigDecimal getCreditLocalAmount()
	{
		return creditLocalAmount;
	}

	public BigDecimal getDebit()
	{
		return debit;
	}

	public BigDecimal getDebitLocalAmount()
	{
		return debitLocalAmount;
	}

	public BigDecimal getManualValues()
	{
		return manualValues;
	}

	public BigDecimal getRemainingCredit()
	{
		return remainingCredit;
	}

	public BigDecimal getRemainingDebit()
	{
		return remainingDebit;
	}

	public Boolean getFullyMatched()
	{
		return fullyMatched;
	}

	public Boolean getManuallyFullyMatched()
	{
		return manuallyFullyMatched;
	}

	public DTOGenericDimensions getDimensions()
	{
		return dimensions;
	}

	public Date getOriginCreationDate()
	{
		return originCreationDate;
	}

	public Date getValueDate()
	{
		return valueDate;
	}

	public EntityReferenceData getAccountRef()
	{
		return accountRef;
	}

	public EntityReferenceData getFiscalPeriod()
	{
		return fiscalPeriod;
	}

	public EntityReferenceData getOrigin()
	{
		return origin;
	}

	public EntityReferenceData getSubsidiary()
	{
		return subsidiary;
	}

	public String getEffectType()
	{
		return effectType;
	}

	public String getEntityDimension()
	{
		return entityDimension;
	}

	public String getLedgerReqId()
	{
		return ledgerReqId;
	}

	public String getLedgerTransLineId()
	{
		return ledgerTransLineId;
	}

	public String getSearchIndex()
	{
		return searchIndex;
	}

	public void setAccountRef(EntityReferenceData accountRef)
	{
		this.accountRef = accountRef;
	}

	public void setCredit(BigDecimal credit)
	{
		this.credit = credit;
	}

	public void setCreditLocalAmount(BigDecimal creditLocalAmount)
	{
		this.creditLocalAmount = creditLocalAmount;
	}

	public void setDebit(BigDecimal debit)
	{
		this.debit = debit;
	}

	public void setDebitLocalAmount(BigDecimal debitLocalAmount)
	{
		this.debitLocalAmount = debitLocalAmount;
	}

	public void setDimensions(DTOGenericDimensions dimensions)
	{
		this.dimensions = dimensions;
	}

	public void setEffectType(String effectType)
	{
		this.effectType = effectType;
	}

	public void setEntityDimension(String entityDimension)
	{
		this.entityDimension = entityDimension;
	}

	public void setFiscalPeriod(EntityReferenceData fiscalPeriod)
	{
		this.fiscalPeriod = fiscalPeriod;
	}

	public void setFullyMatched(Boolean fullyMatched)
	{
		this.fullyMatched = fullyMatched;
	}

	public void setLedgerReqId(String ledgerReqId)
	{
		this.ledgerReqId = ledgerReqId;
	}

	public void setLedgerTransLineId(String ledgerTransLineId)
	{
		this.ledgerTransLineId = ledgerTransLineId;
	}

	public void setManualValues(BigDecimal manualValues)
	{
		this.manualValues = manualValues;
	}

	public void setManuallyFullyMatched(Boolean manuallyFullyMatched)
	{
		this.manuallyFullyMatched = manuallyFullyMatched;
	}

	public void setOrigin(EntityReferenceData origin)
	{
		this.origin = origin;
	}

	public void setOriginCreationDate(Date originCreationDate)
	{
		this.originCreationDate = originCreationDate;
	}

	public void setRemainingCredit(BigDecimal remainingCredit)
	{
		this.remainingCredit = remainingCredit;
	}

	public void setRemainingDebit(BigDecimal remainingDebit)
	{
		this.remainingDebit = remainingDebit;
	}

	public void setSearchIndex(String searchIndex)
	{
		this.searchIndex = searchIndex;
	}

	public void setSubsidiary(EntityReferenceData subsidiary)
	{
		this.subsidiary = subsidiary;
	}

	public void setValueDate(Date valueDate)
	{
		this.valueDate = valueDate;
	}

}
