/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.tools.Data;
import eu.hansolo.medusa.tools.Helper;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MovingAverage {
    public static final int MAX_PERIOD = 1000;
    private static final int DEFAULT_PERIOD = 10;
    private final Queue<Data> window;
    private int numberPeriod;
    private double sum;

    public MovingAverage() {
        this(10);
    }

    public MovingAverage(int NUMBER_PERIOD) {
        this.numberPeriod = Helper.clamp(0, 1000, NUMBER_PERIOD);
        this.window = new ConcurrentLinkedQueue<Data>();
    }

    public void addData(Data DATA) {
        this.sum += DATA.getValue();
        this.window.add(DATA);
        if (this.window.size() > this.numberPeriod) {
            this.sum -= this.window.remove().getValue();
        }
    }

    public void addValue(double VALUE) {
        this.addData(new Data(VALUE));
    }

    public Queue<Data> getWindow() {
        return new LinkedList<Data>(this.window);
    }

    public double getAverage() {
        if (this.window.isEmpty()) {
            return 0.0;
        }
        return this.sum / (double)this.window.size();
    }

    public double getTimeBasedAverageOf(Duration DURATION) {
        assert (!DURATION.isNegative()) : "Time period must be positive";
        Instant now = Instant.now();
        double average = this.window.stream().filter(v -> v.getTimestamp().isAfter(now.minus(DURATION))).mapToDouble(Data::getValue).average().getAsDouble();
        return average;
    }

    public void reset() {
        this.window.clear();
    }
}

