/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.ConsoleProgressHandler;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.Platform;
import com.namasoft.upgrader.ProcessesUtil;
import com.namasoft.upgrader.UpgradeInfoProvider;
import com.namasoft.upgrader.Upgrader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import java.util.Scanner;

public class AutoUpgrader {
    private static ByteArrayOutputStream writer;
    private static Date startedAt;

    public static void upgrade(UpgradeInfoProvider provider) {
        try {
            boolean outputToFile;
            String latestRelease;
            if (writer != null) {
                provider.errorMsg("There is already an upgrader started at " + String.valueOf(startedAt));
                provider.errorMsg(AutoUpgrader.getStatus("-"));
                return;
            }
            writer = new ByteArrayOutputStream();
            startedAt = new Date();
            boolean error = !provider.canMakeUpgrade();
            try (Scanner scanner = new Scanner(new URL(provider.fetchCrmNamasoftUrl() + "/nlm/download.php?releasename=get&subr=" + provider.getSubRelease()).openStream(), "UTF-8").useDelimiter("\\A");){
                latestRelease = scanner.next();
            }
            String current = provider.getApplicationVersion();
            if (latestRelease.equalsIgnoreCase(current) && !provider.isForcedUpdate()) {
                provider.errorMsg("You already have latest release");
                if (!provider.isForcedUpdate()) {
                    error = true;
                }
            }
            if (provider.getCustomerName() == null || provider.getCustomerName().isEmpty()) {
                provider.errorMsg("You must specify customer name in nama.properties (customer=xyz),");
                provider.errorMsg(" you can use this url to set the customer name remotely");
                provider.errorMsg("test?setprop=customer@@@customername");
                error = true;
            }
            if (provider.getTomcatServiceName() == null || provider.getTomcatServiceName().isEmpty()) {
                provider.errorMsg("You must specify tomcat service name in nama.properties (tomcatservice=tomcatxxx)");
                provider.errorMsg("You can use this url to set the service name remotely");
                List<String> availableTomcatServices = Upgrader.getAvailableTomcatServices();
                for (String tomcat : availableTomcatServices) {
                    provider.errorMsg("test?setprop=tomcatservice@@@" + tomcat);
                }
                error = true;
            }
            if (error) {
                writer = null;
                return;
            }
            File workingDirectory = new File(".");
            if ((workingDirectory = workingDirectory.getAbsoluteFile().getParentFile()).getAbsoluteFile().getName().equalsIgnoreCase("bin")) {
                workingDirectory = workingDirectory.getParentFile();
            }
            File jarFile = new File(workingDirectory, provider.JAR_NAME());
            jarFile.delete();
            Object upgraderPath = "bin/";
            if (provider.getSubRelease() != null && !provider.getSubRelease().isEmpty()) {
                upgraderPath = "sub-releases/" + provider.getSubRelease() + "/bin/";
            }
            FileDownloader.download("https://namasoft.com/" + (String)upgraderPath + provider.JAR_NAME(), new ConsoleProgressHandler(), jarFile);
            if (provider.getWorkingDirectory() != null && !provider.getWorkingDirectory().isEmpty()) {
                workingDirectory = new File(provider.getWorkingDirectory());
            }
            provider.upgradeAboutToStart();
            String debugParam = System.getProperty("dbg-upgraer-param");
            if (debugParam == null || debugParam.isEmpty()) {
                debugParam = "-DxDummyPNama=y";
            }
            boolean bl = outputToFile = provider != null && provider.outputToFile();
            if (Platform.isWindows()) {
                ProcessesUtil.runProcessToStream(writer, workingDirectory, "cmd", "/c", "start", "java", debugParam, "-Doutputtofile=" + outputToFile, "-jar", jarFile.getAbsolutePath());
            } else {
                ProcessesUtil.runProcessToStream(writer, workingDirectory, "nohup", "java", debugParam, "-Doutputtofile=" + outputToFile, "-jar", jarFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            startedAt = null;
            writer = null;
        }
    }

    public static String getStatus(String currentRelease) throws IOException {
        File file = new File("upgrader-output.txt");
        if (!file.exists()) {
            return "No upgrader is running, current release is: " + currentRelease;
        }
        return Files.readString(file.toPath());
    }
}

