/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.Platform;
import com.namasoft.upgrader.ProcessesUtil;
import com.namasoft.upgrader.ProgressHandler;
import com.namasoft.upgrader.UIUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileDownloader {
    private static boolean forceUseWGET = false;

    public static File downloadLarge(String url, ProgressHandler progressHandler, File destination) throws IOException, InterruptedException {
        if (FileDownloader.shouldUseNormalDownloadMethod()) {
            return FileDownloader.download(url, progressHandler, destination);
        }
        if (System.getProperty(url) != null && !System.getProperty(url).isEmpty()) {
            return new File(System.getProperty(url));
        }
        if (url.contains("&cst=") && System.getProperty("cstfile") != null && !System.getProperty("cstfile").isEmpty()) {
            return new File(System.getProperty("cstfile"));
        }
        if (url.contains("extras.zip") && System.getProperty("extrasfile") != null && !System.getProperty("extrasfile").isEmpty()) {
            return new File(System.getProperty("extrasfile"));
        }
        String wget = "wget";
        if (Platform.isWindows()) {
            File file;
            File system32WGET = new File(new File(System.getenv("SystemRoot"), "system32"), "wget.exe");
            File file2 = file = UIUtils.isAdmin() || system32WGET.exists() ? system32WGET : new File("wget.exe");
            if (!file.exists()) {
                FileDownloader.download("https://namasoft.com/bin/wget.exe", progressHandler, file);
            }
            wget = "wget.exe";
        }
        ProcessesUtil.runProcessToConsole(wget, url, "-O", destination.getAbsolutePath());
        return destination;
    }

    public static void setForceUseWGET(boolean forceUseWGET) {
        FileDownloader.forceUseWGET = forceUseWGET;
    }

    private static boolean shouldUseNormalDownloadMethod() {
        if (forceUseWGET) {
            return false;
        }
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return !classPath.toLowerCase().contains("wget");
    }

    public static File download(String url, ProgressHandler progressHandler, File destination) throws IOException {
        long currentRead;
        if (System.getProperty(url) != null && !System.getProperty(url).isEmpty()) {
            return new File(System.getProperty(url));
        }
        if (url.contains("&cst=") && System.getProperty("cstfile") != null && !System.getProperty("cstfile").isEmpty()) {
            return new File(System.getProperty("cstfile"));
        }
        if (url.contains("extras.zip") && System.getProperty("extrasfile") != null && !System.getProperty("extrasfile").isEmpty()) {
            return new File(System.getProperty("extrasfile"));
        }
        URL website = new URL(url);
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        progressHandler.setToPath(destination.getAbsolutePath());
        progressHandler.setUrl(url);
        URLConnection connection = website.openConnection();
        connection.setConnectTimeout(Integer.MAX_VALUE);
        connection.setReadTimeout(Integer.MAX_VALUE);
        ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
        FileOutputStream fos = new FileOutputStream(destination);
        progressHandler.onContentLengthAvailaible(connection.getContentLength());
        long read = 0L;
        int bufferSize = 10240;
        if (System.getProperty("buffersize") != null) {
            bufferSize = Integer.parseInt(System.getProperty("buffersize"));
        }
        while ((currentRead = fos.getChannel().transferFrom(rbc, read, bufferSize)) > 0L) {
            progressHandler.onReadProgress(read += currentRead);
            fos.flush();
        }
        rbc.close();
        fos.close();
        return destination;
    }

    public static BigDecimal percent(long read, int maximum) {
        double percent = FileDownloader.d(read) * FileDownloader.d(10000L) / FileDownloader.d(maximum);
        BigDecimal percentExact = new BigDecimal(Math.ceil(percent)).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return percentExact;
    }

    private static double d(long read) {
        return read;
    }

    public static File timeStampedFile(String prefix, String destination, String url) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss");
        return new File(new File(destination).getAbsolutePath() + "/" + prefix + format.format(date) + "." + url.substring(url.lastIndexOf(46)));
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

