/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.application.ScaleScreen;
import com.namasoft.erp.weightscale.application.WeightScaleMainScreen;
import com.namasoft.erp.weightscale.controls.NamaControlType;
import com.namasoft.erp.weightscale.controls.NamaHBox;
import com.namasoft.erp.weightscale.controls.NamaLabeledControl;
import com.namasoft.erp.weightscale.controls.NamaVBox;
import com.namasoft.erp.weightscale.utils.ScaleAPIImpl;
import com.namasoft.erp.weightscale.utils.ServiceProvider;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import com.namasoft.modules.supplychain.contracts.DTOParseWeightBarcodeResponse;
import java.math.BigDecimal;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.TilePane;

public class WeightScaleHeader
extends NamaVBox {
    private NamaLabeledControl<String> barcodeField;
    private NamaLabeledControl<String> verifyingCodeField;
    private NamaLabeledControl<String> lineCode;
    private NamaLabeledControl<String> stockIssueReqCode;
    private NamaLabeledControl<String> itemCode;
    private NamaLabeledControl<String> requiredQty;
    private NamaLabeledControl<String> weightPackage;
    private NamaLabeledControl<String> allowedQtyDeviation;
    private NamaLabeledControl<String> computedField1;
    private NamaLabeledControl<String> computedField2;
    private static BigDecimal qtyDeviationVal;
    private static BigDecimal requiredQtyVal;
    private WeightScaleMainScreen mainScreen;
    private ScaleScreen scaleScreen;
    private NamaLabeledControl<String> scalePortNumber;
    private NamaLabeledControl<String> printerName;
    private NamaLabeledControl<String> user;
    private NamaLabeledControl<String> scaleSerialNum;
    private String rackCode;
    private String requestEntityType;

    public WeightScaleHeader(double screenWidth, WeightScaleMainScreen mainScreen) {
        super(new Node[0]);
        this.setId("mainContainer");
        this.setSpacing(0.0);
        this.mainScreen = mainScreen;
        this.scaleScreen = mainScreen.getScaleScreen();
        this.buildHeader(screenWidth);
    }

    private void buildHeader(double screenWidth) {
        this.defineBarcodeField();
        this.defineRackCodeField();
        NamaHBox barcodesBox = new NamaHBox(new Node[]{this.barcodeField, this.verifyingCodeField});
        barcodesBox.setSpacing(100.0);
        barcodesBox.setPadding(new Insets(30.0, 0.0, 0.0, 5.0));
        NamaVBox generalInfoBox = this.defineGeneralInfoBox();
        NamaHBox namaHBox = new NamaHBox(new Node[]{barcodesBox, generalInfoBox});
        namaHBox.getChildren().forEach(child -> NamaHBox.setHgrow((Node)child, (Priority)Priority.ALWAYS));
        barcodesBox.setAlignment(Pos.TOP_LEFT);
        namaHBox.setPadding(new Insets(0.0));
        this.getChildren().addAll((Object[])new Node[]{namaHBox, this.itemInfoBox(screenWidth)});
    }

    private void defineBarcodeField() {
        this.barcodeField = new NamaLabeledControl(WeightScaleTranslator.translate("barcode", new Object[0]), NamaControlType.TextField);
        this.barcodeField.requestFocus();
        this.barcodeField.setOnKeyPressed(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            WeightScaleResult result = new WeightScaleResult();
            DTOParseWeightBarcodeResponse response = ServiceProvider.getInstance().parseBarcode(this.barcodeField.fetchValue(), result);
            if (result.isFailed()) {
                WeightScaleUtils.showError(result);
                return;
            }
            this.lineCode.insertValue(response.getLineCode());
            this.stockIssueReqCode.insertValue(response.getStockIssueReqCode());
            this.requestEntityType = ObjectChecker.toStringOrEmpty((Object)response.getRequestEntityType());
            this.itemCode.insertValue(response.getItemCode());
            requiredQtyVal = response.getRequiredQty();
            this.requiredQty.insertValue(requiredQtyVal.toString() + "/" + response.getUom().getCode());
            this.weightPackage.insertValue(response.getWeightPackage());
            this.rackCode = response.getRackCode();
            qtyDeviationVal = response.getQtyDeviationValue();
            this.allowedQtyDeviation.insertValue((String)(ObjectChecker.isEmptyOrNull((Object)qtyDeviationVal) ? "0" : qtyDeviationVal.toString() + "/" + response.getUom().getCode()));
            this.computedField1.insertValue(ObjectChecker.toStringOrEmpty((Object)response.getComputedField1()));
            this.computedField2.insertValue(ObjectChecker.toStringOrEmpty((Object)response.getComputedField2()));
            this.scaleScreen.settings(requiredQtyVal.doubleValue(), qtyDeviationVal.doubleValue(), response.getUom(), response.getUomFractionDecimalPlaces(), response.getLocator());
            this.verifyingCodeField.requestFocus();
            Platform.runLater(() -> this.verifyingCodeField.requestFocus());
            this.disable(false);
        });
    }

    private void defineRackCodeField() {
        this.verifyingCodeField = new NamaLabeledControl(WeightScaleTranslator.translate("verifyingCode", new Object[0]), NamaControlType.PasswordField);
        this.verifyingCodeField.setOnKeyPressed(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            if (ObjectChecker.areEqual((Object)this.verifyingCodeField.fetchValue(), (Object)this.rackCode)) {
                if (ObjectChecker.isEmptyOrNull((Object)WeightScaleUtils.serialNumber)) {
                    Optional result = new Alert(Alert.AlertType.ERROR, WeightScaleTranslator.translate("There is no connection between the app and scale. Please connect them", new Object[0]), new ButtonType[]{ButtonType.OK, ButtonType.CLOSE}).showAndWait();
                    if (result.isPresent() && ObjectChecker.areEqual(result.get(), (Object)ButtonType.OK)) {
                        ScaleAPIImpl.getInstance().powerOn();
                    }
                    return;
                }
                this.mainScreen.measurePhase();
                this.barcodeField.setDisable(true);
                this.verifyingCodeField.setDisable(true);
                ScaleAPIImpl.getInstance().measure();
            } else {
                WeightScaleUtils.showError("Invalid rack code");
            }
        });
    }

    private NamaVBox defineGeneralInfoBox() {
        this.user = this.createGeneralInfoField("user", WeightScaleUtils.user);
        this.scalePortNumber = this.createGeneralInfoField("portNumber", WeightScaleUtils.fetchPortNumber());
        this.printerName = this.createGeneralInfoField("printerName", WeightScaleUtils.fetchPrinterName());
        this.scaleSerialNum = this.createGeneralInfoField("serialNumber", WeightScaleUtils.serialNumber);
        Label control = (Label)this.scaleSerialNum.getControl();
        control.textProperty().bind((ObservableValue)WeightScaleUtils.serialNumber);
        NamaVBox generalInfoBox = new NamaVBox(new Node[]{this.user, this.scalePortNumber, this.printerName, this.scaleSerialNum});
        return generalInfoBox;
    }

    private NamaLabeledControl<String> createGeneralInfoField(String fieldId, Object fieldVal) {
        NamaLabeledControl<String> field = new NamaLabeledControl<String>(fieldId, NamaControlType.Label);
        field.insertValue((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{ObjectChecker.toStringOrEmpty((Object)fieldVal), WeightScaleUtils.DISCONNECTED}));
        return field;
    }

    public void updateSerialNum(String serialNo) {
        NaMaLogger.info((Object)("updateSerialNum: " + serialNo));
        this.scaleSerialNum.insertValue((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{ObjectChecker.toStringOrEmpty((Object)serialNo), WeightScaleUtils.DISCONNECTED}));
    }

    private NamaHBox itemInfoBox(double screenWidth) {
        TilePane pane = new TilePane();
        pane.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        pane.setPrefColumns(3);
        pane.setTileAlignment(Pos.BASELINE_LEFT);
        pane.setPadding(new Insets(10.0));
        pane.setMinWidth(screenWidth / 1.5);
        pane.setHgap(10.0);
        this.lineCode = this.createHeaderField("lineCode");
        this.stockIssueReqCode = this.createHeaderField("stockIssueReqCode");
        this.itemCode = this.createHeaderField("itemCode");
        this.requiredQty = this.createHeaderField("requiredQty");
        this.weightPackage = this.createHeaderField("weightPackage");
        this.allowedQtyDeviation = this.createHeaderField("allowedQtyDeviation");
        this.computedField1 = this.createHeaderField("computedField1");
        this.computedField2 = this.createHeaderField("computedField2");
        pane.getChildren().addAll((Object[])new Node[]{this.lineCode, this.stockIssueReqCode, this.itemCode, this.requiredQty, this.weightPackage, this.allowedQtyDeviation});
        NamaVBox computedFields = new NamaVBox(new Node[]{this.computedField1, this.computedField2});
        return new NamaHBox(new Node[]{pane, computedFields});
    }

    private NamaLabeledControl<String> createHeaderField(String title) {
        NamaLabeledControl<String> headerField = new NamaLabeledControl<String>(title, NamaControlType.Label);
        return headerField;
    }

    public static double fetchReqQtyPlusQtyDeviation() {
        return NaMaMath.sum((BigDecimal[])new BigDecimal[]{requiredQtyVal, qtyDeviationVal}).doubleValue();
    }

    public static double getRequiredQtyVal() {
        return requiredQtyVal.doubleValue();
    }

    public String getStockIssueReqCode() {
        return this.stockIssueReqCode.fetchValue();
    }

    public String getLineCode() {
        return this.lineCode.fetchValue();
    }

    public String getRequestEntityType() {
        return this.requestEntityType;
    }

    public String getItemCode() {
        return this.itemCode.fetchValue();
    }

    public void reset() {
        this.setDisable(false);
        this.barcodeField.setDisable(false);
        this.verifyingCodeField.setDisable(false);
        this.barcodeField.reset();
        this.barcodeField.requestFocus();
        this.verifyingCodeField.reset();
        this.lineCode.reset();
        this.stockIssueReqCode.reset();
        this.itemCode.reset();
        this.requiredQty.reset();
        this.weightPackage.reset();
        this.allowedQtyDeviation.reset();
        this.computedField1.reset();
        this.computedField2.reset();
    }

    public void disable(boolean disable) {
        this.verifyingCodeField.setDisable(disable);
    }
}

