/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.application;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.application.ScaleScreen;
import com.namasoft.erp.weightscale.application.WeightScaleHeader;
import com.namasoft.erp.weightscale.controls.NamaBorderPane;
import com.namasoft.erp.weightscale.controls.NamaButton;
import com.namasoft.erp.weightscale.controls.NamaVBox;
import com.namasoft.erp.weightscale.utils.ScaleAPIImpl;
import com.namasoft.erp.weightscale.utils.ServiceProvider;
import com.namasoft.erp.weightscale.utils.WeightScaleGeneralSettings;
import com.namasoft.erp.weightscale.utils.WeightScaleHandler;
import com.namasoft.erp.weightscale.utils.WeightScaleMediaUtil;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import com.namasoft.erp.weightscale.utils.WeightScaleScreen;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import java.math.BigDecimal;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class WeightScaleMainScreen
extends NamaBorderPane {
    private ScaleScreen scaleScreen;
    private ProgressIndicator progressIndicator;
    private WeightScaleHeader scaleHeader;
    private NamaVBox buttonsBox;
    private NamaButton tareBtn;
    private NamaButton printStickerBtn;
    private NamaButton zeroBtn;
    private NamaButton resetBtn;
    private NamaButton reprintBtn;
    private NamaButton reconnectBtn;
    private NamaButton logoutBtn;
    private NamaVBox basicBtns;
    private NamaVBox extraBtns;
    private Pair<String, String> lastLineTempPrintIdPair = new Pair(null, null);

    public ScaleScreen getScaleScreen() {
        return this.scaleScreen;
    }

    public WeightScaleMainScreen(double screenWidth) {
        if (com.namasoft.upgrader.Platform.isInDebugMode()) {
            VBox root = new VBox();
            Button increase = new Button("Increase");
            increase.setOnMouseClicked(e -> this.scaleScreen.updateNetWeight(this.scaleScreen.getNetWeight() + 1.0, "G"));
            Button decrease = new Button("Decrease");
            decrease.setOnMouseClicked(e -> this.scaleScreen.updateNetWeight(this.scaleScreen.getNetWeight() - 1.0, "G"));
            root.getChildren().addAll((Object[])new Node[]{increase, decrease});
            Scene scene = new Scene((Parent)root, 320.0, 240.0);
            Stage stage = new Stage();
            stage.setTitle("Scale");
            stage.setScene(scene);
            stage.show();
        }
        this.scaleScreen = new ScaleScreen(screenWidth);
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setVisible(false);
        this.scaleHeader = new WeightScaleHeader(screenWidth, this);
        this.buildButtonsBox();
        this.waitingForBarcodePhase();
        this.setTop((Node)this.scaleHeader);
        this.setCenter((Node)new StackPane(new Node[]{this.scaleScreen, this.progressIndicator}));
        this.setRight((Node)this.buttonsBox);
        ScaleAPIImpl.getInstance().setMeasureCallback((weight, unit) -> this.scaleScreen.updateNetWeight(weight.floatValue(), (String)unit));
        ScaleAPIImpl.getInstance().setTareCallback(o -> this.scaleScreen.tareAction());
        ScaleAPIImpl.getInstance().setZeroCallback(o -> {
            this.zero();
            ScaleAPIImpl.getInstance().measure();
        });
    }

    private void buildButtonsBox() {
        this.buttonsBox = new NamaVBox(new Node[0]);
        this.defineTareBtn();
        this.definePrintStickerBtn();
        this.defineResetBtn();
        this.defineZeroBtn();
        this.basicBtns = new NamaVBox(new Node[]{this.tareBtn, this.printStickerBtn, this.resetBtn});
        this.basicBtns.getChildren().forEach(child -> NamaVBox.setVgrow((Node)child, (Priority)Priority.ALWAYS));
        this.buttonsBox.getChildren().addAll((Object[])new Node[]{this.basicBtns, this.zeroBtn});
        this.extraBtns = new NamaVBox(new Node[0]);
        if (WeightScaleGeneralSettings.getCanReprint().booleanValue()) {
            this.defineReprintBtn();
            this.extraBtns.getChildren().add((Object)this.reprintBtn);
        }
        this.defineReconnectBtn();
        this.defineLogoutBtn();
        this.extraBtns.getChildren().addAll((Object[])new Node[]{this.reconnectBtn, this.logoutBtn});
        this.extraBtns.getChildren().forEach(child -> NamaVBox.setVgrow((Node)child, (Priority)Priority.ALWAYS));
        this.buttonsBox.getChildren().addAll((Object[])new Node[]{this.extraBtns});
        this.buttonsBox.getChildren().forEach(child -> NamaVBox.setVgrow((Node)child, (Priority)Priority.ALWAYS));
    }

    private void defineTareBtn() {
        this.tareBtn = new NamaButton("packageWeight");
        this.tareBtn.setOnMouseClicked(e -> {
            if (com.namasoft.upgrader.Platform.isInDebugMode()) {
                WeightScaleHandler.weightScaleTareCB.done(null);
            }
            ScaleAPIImpl.getInstance().cancel();
            ScaleAPIImpl.getInstance().cancel();
            ScaleAPIImpl.getInstance().tare();
            ScaleAPIImpl.getInstance().measure();
            this.printStickerBtn.setDisable(false);
            this.tareBtn.setDisable(true);
        });
    }

    private void definePrintStickerBtn() {
        this.printStickerBtn = new NamaButton("printSticker");
        Runnable task = () -> {
            WeightScaleResult result = new WeightScaleResult();
            ScaleAPIImpl.getInstance().cancel();
            this.progressIndicator.setVisible(true);
            this.buttonsBox.setDisable(true);
            this.lastLineTempPrintIdPair.setX((Object)this.scaleHeader.getLineCode());
            this.lastLineTempPrintIdPair.setY((Object)ServiceProvider.getInstance().writePreparationDoc(this.scaleHeader.getRequestEntityType(), this.scaleHeader.getLineCode(), BigDecimal.valueOf(this.scaleScreen.getNetWeight()), BigDecimal.valueOf(this.scaleScreen.getPackageWeight()), result));
            this.buttonsBox.setDisable(false);
            if (result.isFailed()) {
                Platform.runLater(() -> {
                    ScaleAPIImpl.getInstance().measure();
                    WeightScaleUtils.showError(result);
                });
            } else {
                WeightScaleUtils.printSticker(this.lastLineTempPrintIdPair, result);
                Platform.runLater(() -> {
                    if (result.isFailed()) {
                        WeightScaleUtils.showError(result.getArMessage());
                    }
                    this.reset();
                });
            }
            this.progressIndicator.setVisible(false);
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.printStickerBtn.setOnMouseClicked(e -> {
            if (!LoggingConfigurator.isInDebugMode() && ObjectChecker.isFalse((Boolean)WeightScaleUtils.isStableWeightFlag)) {
                WeightScaleUtils.showError("Unstable weight");
                return;
            }
            if (this.scaleScreen.getNetWeight() < WeightScaleHeader.getRequiredQtyVal() || this.scaleScreen.getNetWeight() > WeightScaleHeader.fetchReqQtyPlusQtyDeviation()) {
                WeightScaleResult r = new WeightScaleResult();
                r.failure("Net weight must be between {0} {1} and {2} {3}", this.scaleScreen.getMinWeight().getQty(), this.scaleScreen.getMinWeight().getUom().name(), this.scaleScreen.getMaxWeight().getQty(), this.scaleScreen.getMaxWeight().getUom().name());
                WeightScaleUtils.showError(r);
                return;
            }
            executor.execute(task);
        });
    }

    private void defineZeroBtn() {
        this.zeroBtn = new NamaButton("zero");
        this.zeroBtn.setId("zeroBtn");
        this.zeroBtn.setOnMouseClicked(e -> {
            ScaleAPIImpl.getInstance().zero();
            if (com.namasoft.upgrader.Platform.isInDebugMode()) {
                WeightScaleHandler.weightScaleZeroCB.done(null);
            }
        });
    }

    private void defineResetBtn() {
        this.resetBtn = new NamaButton("reset");
        this.resetBtn.setId("resetBtn");
        this.resetBtn.setOnAction(e -> this.reset());
    }

    private void defineReprintBtn() {
        this.reprintBtn = new NamaButton("reprint");
        this.reprintBtn.setId("reprintBtn");
        this.reprintBtn.setOnAction(e -> {
            WeightScaleResult result = new WeightScaleResult();
            this.progressIndicator.setVisible(true);
            this.buttonsBox.setDisable(true);
            WeightScaleUtils.printSticker(this.lastLineTempPrintIdPair, result);
            Platform.runLater(() -> {
                if (result.isFailed()) {
                    WeightScaleUtils.showError(result.getArMessage());
                }
            });
            this.progressIndicator.setVisible(false);
            this.buttonsBox.setDisable(false);
        });
    }

    private void defineReconnectBtn() {
        this.reconnectBtn = new NamaButton("reconnect");
        this.reconnectBtn.setId("reconnectBtn");
        this.reconnectBtn.setOnAction(e -> ScaleAPIImpl.getInstance().reconnect());
    }

    private void defineLogoutBtn() {
        this.logoutBtn = new NamaButton("logout");
        this.logoutBtn.setId("exit");
        this.logoutBtn.setOnAction(e -> WeightScaleMainScreen.logoutAction());
    }

    public static void logoutAction() {
        WeightScaleMediaUtil.stopPlayer();
        ScaleAPIImpl.getInstance().cancel();
        WeightScaleUtils.drawScreen(WeightScaleScreen.LoginScreen);
    }

    private void reset() {
        ScaleAPIImpl.getInstance().cancel();
        ScaleAPIImpl.getInstance().serialNumber();
        this.scaleHeader.reset();
        this.scaleScreen.reset();
        this.waitingForBarcodePhase();
    }

    private void zero() {
        this.scaleScreen.zero();
        this.tareBtn.setDisable(false);
    }

    public void waitingForBarcodePhase() {
        this.basicBtns.setDisable(true);
        this.extraBtns.setDisable(false);
        this.scaleScreen.setDisable(true);
    }

    public void measurePhase() {
        this.scaleScreen.setDisable(false);
        if (this.scaleScreen.getPackageWeight() == null || this.scaleScreen.getPackageWeight() <= 0.0) {
            this.basicBtns.setDisable(false);
            this.printStickerBtn.setDisable(true);
            this.tareBtn.setDisable(false);
            this.extraBtns.setDisable(true);
        } else {
            this.basicBtns.setDisable(false);
            this.printStickerBtn.setDisable(false);
            this.tareBtn.setDisable(true);
            this.extraBtns.setDisable(true);
        }
    }
}

