/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.controls;

import com.namasoft.erp.weightscale.controls.INamaControl;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;

public class NamaButton
extends Button
implements INamaControl<String> {
    public NamaButton() {
        this("");
    }

    public NamaButton(String text) {
        this.setText(WeightScaleTranslator.translate(text, new Object[0]));
        this.setMinWidth(100.0);
        this.setMaxWidth(120.0);
        this.setMinHeight(55.0);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setAlignment(Pos.CENTER);
        this.setWrapText(true);
        this.setOnMouseEntered(e -> this.setEffect((Effect)new DropShadow()));
        this.setOnMouseExited(e -> this.setEffect(null));
        this.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
    }

    @Override
    public void insertValue(String val) {
        this.setText(WeightScaleTranslator.translate(val, new Object[0]));
    }

    @Override
    public String fetchValue() {
        return this.getText();
    }
}

