/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.controls;

import com.namasoft.erp.weightscale.controls.IHasTextController;
import com.namasoft.erp.weightscale.controls.NamaControlType;
import com.namasoft.erp.weightscale.controls.NamaLabel;
import com.namasoft.erp.weightscale.controls.NamaPasswordField;
import com.namasoft.erp.weightscale.controls.NamaTextField;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class NamaLabeledControl<T>
extends HBox
implements IHasTextController<T> {
    private NamaLabel label;
    private IHasTextController<T> control;

    public NamaLabeledControl(String labelText, NamaControlType type) {
        this(labelText, 10.0, type);
    }

    public NamaLabeledControl(String labelText, double space, NamaControlType type) {
        this.setSpacing(space);
        this.label = new NamaLabel(WeightScaleTranslator.translate(labelText, new Object[0]));
        this.label.setId("labeled_label");
        this.control = this.fetchControl(type);
        this.getChildren().addAll((Object[])new Node[]{this.label, (Node)this.control});
    }

    private IHasTextController fetchControl(NamaControlType type) {
        switch (type) {
            case Label: {
                return new NamaLabel("");
            }
            case PasswordField: {
                return new NamaPasswordField();
            }
        }
        return new NamaTextField();
    }

    public Label fetchLabel() {
        return this.label;
    }

    @Override
    public void insertValue(T val) {
        this.control.insertValue(val);
    }

    @Override
    public T fetchValue() {
        return this.control.fetchValue();
    }

    @Override
    public void reset() {
        this.control.reset();
    }

    public Node getControl() {
        return (Node)this.control;
    }

    public void requestFocus() {
        this.getControl().requestFocus();
    }

    public void cssId(String id) {
        this.label.setId(id);
        this.getControl().setId(id);
    }
}

