/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.erp.weightscale.utils.WeightScaleGeneralSettings;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import com.namasoft.modules.supplychain.contracts.DTOFetchWeightScaleConfigResult;
import com.namasoft.modules.supplychain.contracts.DTOParseWeightBarcodeResponse;
import com.namasoft.modules.supplychain.contracts.DTOWriteWeightScalePreparationDocReq;
import com.namasoft.modules.supplychain.contracts.SupplyChainUtilityWS;
import java.math.BigDecimal;
import java.util.function.Function;

public class ServiceProvider {
    private static SupplyChainUtilityWS scWS;
    private static ServiceProvider instance;

    private ServiceProvider() {
        if (ServiceProvider.connectionIsDown()) {
            throw new NaMaServiceExcepption(WeightScaleTranslator.translate("Can not connect to server", new Object[0]));
        }
        scWS = (SupplyChainUtilityWS)ServiceUtility.getUtilityServiceClient(SupplyChainUtilityWS.class);
    }

    public static ServiceProvider getInstance() {
        if (instance == null) {
            instance = new ServiceProvider();
        }
        return instance;
    }

    public DTOFetchWeightScaleConfigResult fetchConfiguration() {
        WeightScaleResult result = new WeightScaleResult();
        DTOFetchWeightScaleConfigResult config = (DTOFetchWeightScaleConfigResult)this.sendServiceRequest(new SendRequest(), r -> scWS.fetchWeightScaleConfig((ServiceRequest)r), result);
        if (result.isFailed()) {
            throw new NaMaServiceExcepption((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleTranslator.translate(result.getEnMessage(), new Object[0]), result.getArMessage()}));
        }
        return config;
    }

    public DTOParseWeightBarcodeResponse parseBarcode(String code, WeightScaleResult result) {
        return (DTOParseWeightBarcodeResponse)this.sendServiceRequest(new SendRequest((Object)code), r -> scWS.parsePackageBarcode(r), result);
    }

    public String writePreparationDoc(String requestEntityType, String lineCode, BigDecimal weightedQty, BigDecimal packageWeight, WeightScaleResult result) {
        DTOWriteWeightScalePreparationDocReq writeReq = new DTOWriteWeightScalePreparationDocReq();
        writeReq.setRequestEntityType(requestEntityType);
        writeReq.setLineCode(lineCode);
        writeReq.setWeightedQty(weightedQty);
        writeReq.setPackageWeight(packageWeight);
        return (String)this.sendServiceRequest(new SendRequest((Object)writeReq), r -> {
            GetResult response = scWS.writeWeightScalePreparationDocAndGetTempPrintId(r);
            result.accumulate(response.getResult());
            return response;
        }, result);
    }

    private <T> T sendServiceRequest(SendRequest request, Function<SendRequest, GetResult<T>> function, WeightScaleResult result) {
        if (ServiceProvider.connectionIsDown()) {
            throw new NaMaServiceExcepption(WeightScaleTranslator.translate("Can not connect to server", new Object[0]));
        }
        this.fillSendReqBasicData((ServiceRequest)request);
        Object response = null;
        try {
            response = function.apply(request).getData();
        }
        catch (NaMaServiceExcepption e) {
            NaMaLogger.error((Throwable)e);
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
        }
        return (T)response;
    }

    public ServiceResponse fillPrintedField(String lineCode, WeightScaleResult result) {
        if (ServiceProvider.connectionIsDown()) {
            throw new NaMaServiceExcepption(WeightScaleTranslator.translate("Can not connect to server", new Object[0]));
        }
        SendRequest request = new SendRequest((Object)lineCode);
        this.fillSendReqBasicData((ServiceRequest)request);
        ServiceResponse response = null;
        try {
            response = scWS.updatePreparationDocLinePrintedField(request);
        }
        catch (NaMaServiceExcepption e) {
            NaMaLogger.error((Throwable)e);
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
        }
        return response;
    }

    public static boolean connectionIsUp() {
        return !ServiceProvider.connectionIsDown();
    }

    public static boolean connectionIsDown() {
        return ServiceProvider.noConnection();
    }

    private static boolean noConnection() {
        try {
            ServiceLoginProvider.loginIfNotLoggedIn((String)WeightScaleGeneralSettings.getServerURL(), (String)WeightScaleGeneralSettings.getLoginPassword(), (String)WeightScaleGeneralSettings.getLoginID());
        }
        catch (Exception exception) {
            NaMaLogger.error((Throwable)exception);
            return true;
        }
        return false;
    }

    private void fillSendReqBasicData(ServiceRequest request) {
        request.setLoginId((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleUtils.username, WeightScaleGeneralSettings.getLoginID()}));
        request.setPasswordHash(ServerStringUtils.hash((String)((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleUtils.password, WeightScaleGeneralSettings.getLoginPassword()}))));
    }
}

