/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleQuantity;
import com.namasoft.erp.weightscale.utils.WeightScaleUOM;
import java.math.BigDecimal;

public class WeightProcessInfo {
    private static final double ZERO = 0.0;
    private WeightScaleQuantity netWeight = new WeightScaleQuantity();
    private WeightScaleQuantity packageWeight = new WeightScaleQuantity();
    private WeightScaleQuantity grossWeight = new WeightScaleQuantity();
    private int fractionDecimalPlaces = 2;

    public void init(WeightScaleUOM uom, int fractionDecimalPlaces) {
        this.fractionDecimalPlaces = fractionDecimalPlaces;
        this.netWeight.setUomAndConvert(uom);
        this.packageWeight.setUomAndConvert(uom);
        this.grossWeight.setUomAndConvert(uom);
    }

    public void updateNetWeight(Double weight, String uom) {
        Double weightValue = NaMaMath.round((BigDecimal)BigDecimal.valueOf(weight), (Integer)this.fractionDecimalPlaces).doubleValue();
        if (ObjectChecker.areEqual((Object)((Object)this.netWeight.getUom()), (Object)((Object)WeightScaleUOM.parse(uom)))) {
            this.netWeight.setQty(weightValue);
            this.updateGrossWeight();
        } else {
            this.updateNetWeight(this.convertWeightToRequiredUom(weight, this.netWeight.getUom()), this.netWeight.getUom().toString());
        }
    }

    private Double convertWeightToRequiredUom(Double weight, WeightScaleUOM uom) {
        if (ObjectChecker.areEqual((Object)((Object)uom), (Object)((Object)WeightScaleUOM.KG))) {
            return weight / 1000.0;
        }
        return weight * 1000.0;
    }

    private void updateGrossWeight() {
        Double val = this.netWeight.plus(this.packageWeight);
        this.grossWeight.setQty(NaMaMath.round((BigDecimal)BigDecimal.valueOf(val), (Integer)this.fractionDecimalPlaces).doubleValue());
    }

    public void zero() {
        this.packageWeight.setQty(0.0);
    }

    public void tare() {
        this.packageWeight.setQty(this.netWeight.getQty());
        this.updateNetWeight(0.0, this.netWeight.getUom().toString());
    }

    public WeightScaleQuantity getNetWeight() {
        return this.netWeight;
    }

    public WeightScaleQuantity getPackageWeight() {
        return this.packageWeight;
    }

    public WeightScaleQuantity getGrossWeight() {
        return this.grossWeight;
    }
}

