/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.weightscale.application.WeightScaleLoginScreen;
import com.namasoft.erp.weightscale.application.WeightScaleMainScreen;
import com.namasoft.erp.weightscale.utils.ScaleAPIImpl;
import com.namasoft.erp.weightscale.utils.WeightScaleGeneralSettings;
import com.namasoft.erp.weightscale.utils.WeightScalePreLoader;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.geometry.NodeOrientation;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.InputEvent;
import javafx.stage.Stage;
import javafx.util.Duration;

public class WeightScaleEntryPoint
extends Application {
    private static ServerSocket socket;
    private static final int PORT = 9998;

    public void init() throws Exception {
        if (this.isSystemRunning()) {
            this.alertAndExit();
            return;
        }
        this.initiateShutdownSocketListener();
        WeightScaleGeneralSettings.createSettingsFileIfNotFound();
        WeightScaleGeneralSettings.load();
        ServiceLoginProvider.setServerURL((String)WeightScaleGeneralSettings.getServerURL());
        LoggingConfigurator.setNAMASOFT_LOGFileName((String)"weightscale.log");
        LoggingConfigurator.configureUsingCode((boolean)false);
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> {
            NaMaLogger.error((Throwable)e);
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ErrorNotification("initMethod", "", e));
        });
        WeightScaleTranslator.loadTranslations();
        WeightScaleUtils.setup();
    }

    private boolean isSystemRunning() {
        try {
            socket = new ServerSocket(9998, 0, InetAddress.getLocalHost());
        }
        catch (BindException e) {
            return true;
        }
        catch (IOException e) {
            System.err.println("Unexpected error.");
            e.printStackTrace();
            System.exit(2);
            return true;
        }
        return false;
    }

    private void alertAndExit() throws Exception {
        boolean errors = false;
        try {
            Socket clientSocket = new Socket(InetAddress.getLocalHost(), 9998);
            OutputStream out = clientSocket.getOutputStream();
            String string = "SHOW-SCALE\n";
            out.write(string.getBytes());
            out.close();
            clientSocket.close();
        }
        catch (ConnectException e) {
            NaMaLogger.error((Object)"No running instance of POS was found.", (Throwable)e);
            errors = true;
        }
        catch (IOException e) {
            NaMaLogger.error((Object)"No running instance of POS was found.", (Throwable)e);
            errors = true;
        }
        if (errors) {
            throw new Exception("POS is already running, but could not show it");
        }
        NaMaLogger.info((Object)"Shutting down because another screen was found");
        WeightScaleEntryPoint.terminate();
    }

    private void initiateShutdownSocketListener() {
        if (ObjectChecker.isEmptyOrNull((Object)socket)) {
            return;
        }
        Thread socketListener = new Thread(this, "socketListener"){

            @Override
            public void run() {
                while (!socket.isClosed()) {
                    try {
                        Socket client = socket.accept();
                        BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                        String message = in.readLine();
                        if (message.trim().contains("SHUTDOWN-SCALE")) {
                            NaMaLogger.info((Object)"Shutting down pos to upgrade the release");
                            socket.close();
                            WeightScaleEntryPoint.terminate();
                        } else if (message.contains("SHOW-SCALE")) {
                            NaMaLogger.info((Object)"Showing POS From Different Run");
                            Platform.runLater(() -> {
                                WeightScaleUtils.stage.show();
                                WeightScaleUtils.stage.toFront();
                            });
                        }
                        in.close();
                        client.close();
                    }
                    catch (Exception e) {
                        NaMaLogger.error((Throwable)e);
                    }
                }
            }
        };
        socketListener.start();
        socketListener.setUncaughtExceptionHandler((t, e) -> NaMaLogger.error((Throwable)e));
    }

    public void start(Stage primaryStage) throws Exception {
        WeightScaleUtils.cacheStage(primaryStage);
        WeightScaleLoginScreen loginScreen = new WeightScaleLoginScreen();
        Scene scene = new Scene((Parent)loginScreen, WeightScaleUtils.screenWidth, WeightScaleUtils.screenHeight);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getClassLoader().getResource("application.css").toExternalForm());
        scene.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        primaryStage.setScene(scene);
        primaryStage.setMaximized(true);
        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/scale_icon.jpg")));
        primaryStage.setTitle(WeightScaleTranslator.translate("weightScale", new Object[0]));
        Double delayTime = 900.0;
        if (WeightScaleUtils.config.getLogoutDueToInActivityFor() != null && WeightScaleUtils.config.getLogoutDueToInActivityFor() > 0.0) {
            delayTime = WeightScaleUtils.config.getLogoutDueToInActivityFor() * 60.0;
        }
        Duration delay = Duration.seconds((double)delayTime);
        PauseTransition transition = new PauseTransition(delay);
        transition.setOnFinished(evt -> WeightScaleMainScreen.logoutAction());
        scene.addEventFilter(InputEvent.ANY, evt -> transition.playFromStart());
        primaryStage.setOnCloseRequest(e -> WeightScaleEntryPoint.terminate());
        primaryStage.show();
        transition.play();
        WeightScalePreLoader.closeIfNeeded();
    }

    private static void terminate() {
        try {
            ScaleAPIImpl.getInstance().disconnect();
            socket.close();
        }
        catch (IOException ex) {
            NaMaLogger.error((Throwable)ex);
        }
        finally {
            Platform.exit();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        System.setProperty("prism.lcdtext", "false");
        System.setProperty("prism.text", "t2k");
        System.setProperty("javafx.preloader", WeightScalePreLoader.class.getName());
        Application.launch(WeightScaleEntryPoint.class, (String[])args);
    }
}

