/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.GeneralSettings;
import java.util.Properties;

public class WeightScaleGeneralSettings
extends GeneralSettings {
    private static final String PRINTER_NAME = "printerName";
    private static final String MEASURE_COMMAND = "measureCommand";
    private static final String WEIGHT_SCALE_PORT = "weightScalePort";
    private static final String CAN_REPRINT = "canReprint";

    public static String getLoginPassword() {
        return WeightScaleGeneralSettings.findSecuredPassword((String)"loginpassword", (String)"login");
    }

    public static String getLoginID() {
        return WeightScaleGeneralSettings.getProperty((String)"loginid");
    }

    public static String getServerURL() {
        return WeightScaleGeneralSettings.getProperty((String)"namaServerURL");
    }

    public static String getPrinterName() {
        return WeightScaleGeneralSettings.getProperty((String)PRINTER_NAME);
    }

    public static String getMeasureCommand() {
        return WeightScaleGeneralSettings.getProperty((String)MEASURE_COMMAND);
    }

    public static String getWeightScalePort() {
        return WeightScaleGeneralSettings.getProperty((String)WEIGHT_SCALE_PORT);
    }

    public static Boolean getCanReprint() {
        return ObjectChecker.areEqual((Object)WeightScaleGeneralSettings.getProperty((String)CAN_REPRINT), (Object)"1") || ObjectChecker.isTrue((String)WeightScaleGeneralSettings.getProperty((String)CAN_REPRINT));
    }

    public static void createSettingsFileIfNotFound() {
        properties = null;
        WeightScaleGeneralSettings.setSettingsFilePath((String)"weight-scale.properties");
        if (ObjectChecker.isEmptyOrNull((Object)settingsFilePath)) {
            throw new NullPointerException("Settings File path is empty");
        }
        properties = GeneralSettings.load();
        if (ObjectChecker.isEmptyOrNull((Object)properties)) {
            WeightScaleGeneralSettings.initProperites();
        }
    }

    private static void initProperites() {
        properties.setProperty("defaultlang", "Arabic");
        properties.setProperty("guiserver", "");
        properties.setProperty("namaServerURL", "");
        properties.setProperty("loginid", "admin");
        properties.setProperty("loginpassword", "n@m@s0ft");
        properties.setProperty(PRINTER_NAME, "");
        properties.setProperty(MEASURE_COMMAND, "");
        properties.setProperty(WEIGHT_SCALE_PORT, "");
        properties.setProperty(CAN_REPRINT, "1");
        WeightScaleGeneralSettings.setSettingsFilePath((String)"weight-scale.properties");
        WeightScaleGeneralSettings.saveSetting((Properties)properties, e -> NaMaLogger.error((Throwable)e));
    }
}

