/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;

public class WeightScaleMediaUtil {
    private static final Map<String, MediaPlayer> mediaPlayersCache = new HashMap<String, MediaPlayer>();
    private static final String ALERT_SOUND_FROM_RESOURCES = "alert-from-resources.wav";
    private static final String REACH_WEIGHT_SOUND_FROM_RESOURCES = "reach-required-weight.mp3";
    private static MediaPlayer lastPlayer = null;

    public static void playAlert() {
        WeightScaleMediaUtil.stopPlayer();
        WeightScaleMediaUtil.playSound(ALERT_SOUND_FROM_RESOURCES, -1);
    }

    public static void playReachWeightSound() {
        WeightScaleMediaUtil.stopPlayer();
        WeightScaleMediaUtil.playSound(REACH_WEIGHT_SOUND_FROM_RESOURCES, 1);
    }

    public static void playSound(String path, int cycleCount) {
        if (ObjectChecker.areEqual((Object)path, (Object)"none")) {
            return;
        }
        MediaPlayer player = WeightScaleMediaUtil.fetchMediaPlayerFor(path, cycleCount);
        if (player == null) {
            return;
        }
        player.seek(Duration.ZERO);
        player.play();
        lastPlayer = player;
    }

    private static MediaPlayer fetchMediaPlayerFor(String path, int cycleCount) {
        try {
            MediaPlayer player = mediaPlayersCache.get(path);
            if (player != null) {
                return player;
            }
            player = WeightScaleMediaUtil.addAndGetMediaPlayerFor(path);
            if (player != null) {
                player.setCycleCount(cycleCount);
            }
            mediaPlayersCache.put(path, player);
            return player;
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    private static MediaPlayer addAndGetMediaPlayerFor(String path) throws Exception {
        String uri;
        String actualPath = path.replaceAll("\\\\", "/");
        if (ObjectChecker.isEmptyOrNull((Object)actualPath)) {
            return null;
        }
        if (ObjectChecker.isAnyEqualToFirst((Object)path, (Object[])new String[]{ALERT_SOUND_FROM_RESOURCES, REACH_WEIGHT_SOUND_FROM_RESOURCES})) {
            uri = ObjectChecker.toStringOrEmpty((Object)WeightScaleMediaUtil.class.getClassLoader().getResource(path).toURI());
        } else {
            uri = new File(path).toURI().toString();
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
        }
        Media media = new Media(uri);
        return new MediaPlayer(media);
    }

    public static void stopPlayer() {
        if (lastPlayer == null) {
            return;
        }
        lastPlayer.stop();
    }
}

