/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import java.util.stream.Collectors;
import javafx.application.Preloader;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class WeightScalePreLoader
extends Preloader {
    private Stage stage;
    public static WeightScalePreLoader instance;

    public WeightScalePreLoader() {
        instance = this;
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification info) {
        NaMaLogger.error((Throwable)info.getCause());
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText("Error: ");
        Label errorHeaderLabel = new Label(info.getDetails().concat(": ").concat(" Please check log file for more details"));
        String errorMessage = info.getCause().getMessage();
        if (info.getCause() instanceof NaMaServiceExcepption) {
            String arabicErrorMessage = ResultDTO.findLeafFailureResults((ResultDTO)((NaMaServiceExcepption)info.getCause()).getFaultInfo()).stream().map(ResultDTO::getArabicMessage).collect(Collectors.joining(","));
            String englishErrorMessage = ResultDTO.findLeafFailureResults((ResultDTO)((NaMaServiceExcepption)info.getCause()).getFaultInfo()).stream().map(ResultDTO::getEnglishMessage).collect(Collectors.joining(","));
            if (ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{arabicErrorMessage, englishErrorMessage})) {
                errorMessage = arabicErrorMessage.concat("\n\n").concat(englishErrorMessage);
            }
        }
        Label errorMessageLabel = new Label(errorMessage);
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{errorHeaderLabel, errorMessageLabel});
        errorMessageLabel.setStyle("-fx-font-family: TimesNewRoman; -fx-font-weight:Bold;-fx-font-size: 18;-fx-text-fill: RED");
        alert.getDialogPane().setContent((Node)box);
        alert.showAndWait();
        return true;
    }

    public void start(Stage primaryStage) throws Exception {
        Rectangle2D visualBounds = Screen.getPrimary().getVisualBounds();
        ProgressBar progressBar = new ProgressBar();
        VBox root = new VBox(new Node[]{progressBar});
        progressBar.setPrefWidth(visualBounds.getWidth() / 4.5);
        progressBar.setPrefHeight(50.0);
        root.setAlignment(Pos.CENTER);
        root.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        primaryStage.setScene(new Scene((Parent)root, visualBounds.getWidth() / 4.0, visualBounds.getHeight() / 4.0));
        primaryStage.setTitle(WeightScaleTranslator.translate("weightScale", new Object[0]));
        primaryStage.show();
        this.stage = primaryStage;
    }

    public static void closeIfNeeded() {
        if (instance != null && WeightScalePreLoader.instance.stage != null) {
            WeightScalePreLoader.instance.stage.hide();
        }
    }
}

