/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import java.util.List;

public class WeightScaleResult {
    private boolean failed;
    private String arMessage;
    private String enMessage;

    public boolean isFailed() {
        return this.failed;
    }

    public boolean succeded() {
        return !this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public String getArMessage() {
        return this.arMessage;
    }

    public void setArMessage(String arMessage) {
        this.arMessage = arMessage;
    }

    public String getEnMessage() {
        return this.enMessage;
    }

    public void setEnMessage(String enMessage) {
        this.enMessage = enMessage;
    }

    public void accumulate(WeightScaleResult result) {
        if (!this.failed) {
            this.failed = result.isFailed();
        }
        this.setArMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getArMessage()) ? result.getArMessage() : this.getArMessage() + ",\n" + result.getArMessage()));
        this.setEnMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getArMessage()) ? result.getEnMessage() : this.getEnMessage() + ",\n" + result.getEnMessage()));
    }

    public void accumulate(List<ResultDTO> failures) {
        for (ResultDTO failure : failures) {
            this.accumulate(failure);
        }
    }

    public void accumulate(ResultDTO dto) {
        this.setFailed(dto.isFailed());
        this.setArMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getArMessage()) ? dto.getArabicMessage() : this.arMessage + ",\n" + dto.getArabicMessage()));
        this.setEnMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getEnMessage()) ? dto.getEnglishMessage() : this.enMessage + ",\n" + dto.getEnglishMessage()));
    }

    public void failure(String message, Object ... objects) {
        this.failure(WeightScaleTranslator.translate(message, objects), WeightScaleTranslator.translate(message, objects));
    }

    public void failure(String arMessage, String enMessage) {
        this.setFailed(true);
        this.setArMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getArMessage()) ? arMessage : this.getArMessage() + "\n" + arMessage));
        this.setEnMessage((String)(ObjectChecker.isEmptyOrNull((Object)this.getEnMessage()) ? enMessage : this.getEnMessage() + "\n" + enMessage));
    }

    public static WeightScaleResult createFailureResult(String arMessage, String enMessage) {
        WeightScaleResult result = new WeightScaleResult();
        result.setFailed(true);
        result.setArMessage(arMessage);
        result.setEnMessage(enMessage);
        return result;
    }
}

