/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.DTOHasSubsidiaryAccounts;
import com.namasoft.modules.commonbasic.enums.DefaultUOM;
import com.namasoft.modules.supplychain.contracts.details.DTOItemRevision;
import com.namasoft.modules.supplychain.contracts.details.DTOPrimaryItemUOMLine;
import com.namasoft.modules.supplychain.contracts.details.DTOSizesAndColors;
import com.namasoft.modules.supplychain.contracts.details.GeneratedDTOAbsItemRevision;
import com.namasoft.modules.supplychain.contracts.details.GeneratedDTOAbsSizesAndColors;
import com.namasoft.modules.supplychain.contracts.entities.GeneratedDTOInvItem;
import com.namasoft.modules.supplychain.contracts.entities.IDTOItem;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOInvItem
extends GeneratedDTOInvItem
implements Serializable,
DTOHasSubsidiaryAccounts,
IDTOItem {
    public EntityReferenceData calcPrimaryUOM(String uomStr) {
        if (ObjectChecker.isEmptyOrNull((Object)uomStr)) {
            return this.getPrimaryUOM().getBaseUnit();
        }
        DefaultUOM uom = DefaultUOM.valueOf((String)uomStr);
        switch (uom) {
            case BaseUnit: {
                return this.getPrimaryUOM().getBaseUnit();
            }
            case DefaultPurchaseUnit: {
                return this.getPrimaryUOM().getDefaultPurchaseUnit();
            }
            case DefaultSalesUnit: {
                return this.getPrimaryUOM().getDefaultSalesUnit();
            }
            case ReportingUnit1: {
                return this.getPrimaryUOM().getReportingUnit1();
            }
            case ReportingUnit2: {
                return this.getPrimaryUOM().getReportingUnit2();
            }
        }
        return null;
    }

    public BigDecimal calcQtyInBase(DTORawQuantity qty) {
        if (qty == null || qty.getValue() == null) {
            return BigDecimal.ZERO;
        }
        for (DTOPrimaryItemUOMLine line : this.getPrimaryUnits()) {
            if (!ObjectChecker.areEqual((Object)line.getUom(), (Object)qty.getUom())) continue;
            return NaMaMath.multiply((BigDecimal[])new BigDecimal[]{qty.getValue(), line.getRateToBase()});
        }
        return qty.getValue();
    }

    public BigDecimal calcBaseInUOM(BigDecimal qtyInBase, EntityReferenceData uom) {
        for (DTOPrimaryItemUOMLine line : this.getPrimaryUnits()) {
            if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{line.getUom(), uom}) || !ObjectChecker.areEqual((Object)line.getUom(), (Object)uom)) continue;
            return NaMaMath.divide((BigDecimal)qtyInBase, (BigDecimal)line.getRateToBase(), (Integer)((Integer)uom.get("fractionDecimalPlaces")));
        }
        return qtyInBase;
    }

    public DTOItemRevision fetchItemRevision(String revisionId) {
        return this.getRevisions().stream().filter(dtoItemRevision -> ObjectChecker.areEqual((Object)dtoItemRevision.getRevisionId(), (Object)revisionId)).findFirst().get();
    }

    public String fetchColor(EntityReferenceData color) {
        if (color == null) {
            return "";
        }
        for (DTOSizesAndColors line : this.getSizesAndColors()) {
            if (!ObjectChecker.areEqual((Object)line.getItemColor(), (Object)color)) continue;
            return line.getColor();
        }
        return "";
    }

    public String fetchSize(EntityReferenceData size) {
        if (size == null) {
            return "";
        }
        for (DTOSizesAndColors line : this.getSizesAndColors()) {
            if (!ObjectChecker.areEqual((Object)line.getItemSize(), (Object)size)) continue;
            return line.getSize();
        }
        return "";
    }

    public String fetchRevisionName(String revisionId) {
        DTOItemRevision itemRevision = this.getRevisions().stream().filter(ObjectChecker.equalsPredicate((Object)revisionId, GeneratedDTOAbsItemRevision::getRevisionId)).filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getRevisionName())).findFirst().orElse(null);
        if (itemRevision != null) {
            return itemRevision.getRevisionName();
        }
        return "";
    }

    public String fetchColorName(String color) {
        DTOSizesAndColors sizesAndColors = this.getSizesAndColors().stream().filter(ObjectChecker.equalsPredicate((Object)color, GeneratedDTOAbsSizesAndColors::getColor)).filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getColorName())).findFirst().orElse(null);
        if (sizesAndColors != null) {
            return sizesAndColors.getColorName();
        }
        return "";
    }

    public String fetchSizeName(String size) {
        DTOSizesAndColors sizesAndColors = this.getSizesAndColors().stream().filter(ObjectChecker.equalsPredicate((Object)size, GeneratedDTOAbsSizesAndColors::getSize)).filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getSizeName())).findFirst().orElse(null);
        if (sizesAndColors != null) {
            return sizesAndColors.getSizeName();
        }
        return "";
    }

    public String fetchLevelID(String levelType) {
        switch (levelType) {
            case "ItemSection": {
                return this.fetchIDIfRefNotNull(this.getSection());
            }
            case "ItemClass1": {
                return this.fetchIDIfRefNotNull(this.getItemClass1());
            }
            case "ItemClass2": {
                return this.fetchIDIfRefNotNull(this.getItemClass2());
            }
            case "ItemClass3": {
                return this.fetchIDIfRefNotNull(this.getItemClass3());
            }
            case "ItemClass4": {
                return this.fetchIDIfRefNotNull(this.getItemClass4());
            }
            case "ItemClass5": {
                return this.fetchIDIfRefNotNull(this.getItemClass5());
            }
            case "ItemClass6": {
                return this.fetchIDIfRefNotNull(this.getItemClass6());
            }
            case "ItemClass7": {
                return this.fetchIDIfRefNotNull(this.getItemClass7());
            }
            case "ItemClass8": {
                return this.fetchIDIfRefNotNull(this.getItemClass8());
            }
            case "ItemClass9": {
                return this.fetchIDIfRefNotNull(this.getItemClass9());
            }
            case "ItemClass10": {
                return this.fetchIDIfRefNotNull(this.getItemClass10());
            }
        }
        return "";
    }

    private String fetchIDIfRefNotNull(EntityReferenceData ref) {
        if (ref == null) {
            return "";
        }
        return ref.getId();
    }
}

