/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.httpcommon.IAPIToken;
import java.io.Closeable;
import java.io.IOException;

public interface IClientAPI
extends Closeable {
    public String configId();

    public String getUserName();

    public String getPassword();

    public void loginAndUpdateAccessToken();

    public IAPIToken accessToken();

    default public void validateMissingParamsAndThrowExceptionIfNeeded() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getUserName())) {
            throw new RuntimeException("User Name is missing");
        }
        if (ObjectChecker.isEmptyOrNull((Object)this.getPassword())) {
            throw new RuntimeException("Password is missing");
        }
    }

    default public void safeClose(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }
}

