/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.httpcommon.IAPIToken;
import com.namasoft.httpcommon.IClientAPI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TokenUtils {
    private static final Object tokenLock = new Object();
    private static final Map<String, Pair<IAPIToken, Date>> tokensMap = new ConcurrentHashMap<String, Pair<IAPIToken, Date>>();
    private static final Map<String, String> refreshtokensMap = new ConcurrentHashMap<String, String>();
    private static final Map<String, ScheduledExecutorService> accessTokenExecutorServices = new HashMap<String, ScheduledExecutorService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String token(IClientAPI api) {
        Object object = tokenLock;
        synchronized (object) {
            return TokenUtils.getCachedOrRequestNewToken(api).getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IAPIToken accessTokenObject(IClientAPI api) {
        Object object = tokenLock;
        synchronized (object) {
            return TokenUtils.getCachedOrRequestNewToken(api);
        }
    }

    private static IAPIToken getCachedOrRequestNewToken(IClientAPI api) {
        ScheduledExecutorService executorService = accessTokenExecutorServices.computeIfAbsent(api.configId(), k -> Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "access-token-refresh" + api.configId())));
        if (tokensMap.containsKey(api.configId())) {
            Pair<IAPIToken, Date> token = tokensMap.get(api.configId());
            IAPIToken oldAccessToken = (IAPIToken)token.getX();
            if (token.getY() == null) {
                token.setY((Object)new Date());
            }
            long timeDifferenceInMilliSeconds = new Date().getTime() - ((Date)token.getY()).getTime();
            if (oldAccessToken != null && timeDifferenceInMilliSeconds < ObjectChecker.toZeroIfNull((Long)oldAccessToken.expiredIn())) {
                TokenUtils.scheduleAccessTokenRefresh(executorService, api, timeDifferenceInMilliSeconds);
                return oldAccessToken;
            }
        }
        api.validateMissingParamsAndThrowExceptionIfNeeded();
        api.loginAndUpdateAccessToken();
        IAPIToken accessToken = api.accessToken();
        TokenUtils.scheduleAccessTokenRefresh(executorService, api, accessToken.expiredIn());
        accessToken.updateDate(new Date());
        tokensMap.put(api.configId(), (Pair<IAPIToken, Date>)new Pair((Object)accessToken, (Object)new Date()));
        return accessToken;
    }

    private static void scheduleAccessTokenRefresh(ScheduledExecutorService executorService, IClientAPI api, long afterMilliSeconds) {
        executorService.schedule(() -> TokenUtils.getCachedOrRequestNewToken(api), afterMilliSeconds - 100L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initToken(IClientAPI api) {
        Object object = tokenLock;
        synchronized (object) {
            tokensMap.computeIfAbsent(api.configId(), k -> new Pair((Object)api.accessToken(), api.accessToken() == null ? null : api.accessToken().date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateToken(IClientAPI api) {
        Object object = tokenLock;
        synchronized (object) {
            tokensMap.put(api.configId(), (Pair<IAPIToken, Date>)new Pair((Object)api.accessToken(), api.accessToken() == null ? null : api.accessToken().date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRefreshToken(IClientAPI api, String refreshToken) {
        Object object = tokenLock;
        synchronized (object) {
            refreshtokensMap.put(api.configId(), refreshToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fetchRefreshToken(IClientAPI api) {
        Object object = tokenLock;
        synchronized (object) {
            return refreshtokensMap.get(api.configId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearApiToken(String configId) {
        Object object = tokenLock;
        synchronized (object) {
            tokensMap.remove(configId);
            refreshtokensMap.remove(configId);
        }
    }
}

