package com.namasoft.common;

import com.namasoft.common.flatobjects.IDTOTask;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
public class TaskTracker
{
	private static List<IDTOTask> guiTasks = new CopyOnWriteArrayList<>();

	public static List<IDTOTask> getGuiTasks()
	{
		return guiTasks;
	}

	public static void removeTask(IDTOTask task)
	{
		guiTasks.remove(task);
	}
	public static void removeTaskById(String taskId)
	{
		IDTOTask dtoguiTask = guiTasks.stream().filter(e -> ObjectChecker.areEqual(taskId, e.getTaskId())).findFirst().orElse(null);
		if (ObjectChecker.isNotEmptyOrNull(dtoguiTask))
		{
			dtoguiTask.markForKill();
		}
	}

	public static <T extends IDTOTask> T addTask(T task)
	{
		TaskTracker.getGuiTasks().add(task);
		return task;
	}
}
