package com.namasoft.common.fieldids;

import com.namasoft.common.constants.*;
import com.namasoft.common.utilities.*;

import java.util.*;

public abstract class MobileEntityTypesSuggester
{
	private static final Map<String, List<String>> map = new HashMap<>();

	public static Map<String, List<String>> fetchEntityTypeSuggesterMap(boolean considerSubItemDocuments)
	{
		if (ObjectChecker.isEmptyOrNull(map))
		{
			List<String> basicSCDocumentEntities = CollectionsUtility.asList(SCEntities.QualityControlDoc, SCEntities.QualityControlReq,
					SCEntities.ItemCuttingDoc, SCEntities.MCRawMaterialIssue, SCEntities.StockIssue, SCEntities.StockIssueReq,
					SCEntities.ProcessingDoc, SCEntities.ProformaPurchaseInvoice, SCEntities.PurchaseOrder, SCEntities.PurchaseOrder,
					SCEntities.PurchaseInvoice, SCEntities.PurchaseReturn, SCEntities.ConsolidatedPurchaseReq, SCEntities.FinishedProductPricing,
					SCEntities.ItemRequest, SCEntities.LCProformaInvoice, SCEntities.PurchasePriceComparing, SCEntities.PurchaseQuotation,
					SCEntities.PurchaseQuotationRequest, SCEntities.PurchaseReturnReq, SCEntities.ReceiptInspection, SCEntities.QualityAssuranceDoc,
					SCEntities.QualityAssuranceReq, SCEntities.CostRevaluation, SCEntities.InitialReceipt, SCEntities.OpeningStockDocument,
					SCEntities.StockReceipt, SCEntities.StockReceiptCancellation, SCEntities.StockReceiptReq, SCEntities.GlassJobOrder,
					SCEntities.GlassJobOrderReq, SCEntities.ProformaSalesInvoice, SCEntities.SalesOrder, SCEntities.SalesInvoice,
					SCEntities.SalesReplacement, SCEntities.SalesReturn, SCEntities.SalesReturnRequest, SCEntities.CustomersReqsShortageDoc,
					SCEntities.DeliveryCancellationDoc, SCEntities.DeliveryDocument, SCEntities.LoadingCancellationDoc, SCEntities.LoadingDocument,
					SCEntities.ReservationDocument, SCEntities.ReservationCancellationDoc, SCEntities.SalesForecast, SCEntities.SalesQuotation,
					SCEntities.SalesQuotationRequest, SCEntities.SalesReplacementReq, SCEntities.Tender, SCEntities.StockTakingDetails,
					SCEntities.StockTransfer, SCEntities.StockTransferReq);
			map.put("Remark", CollectionsUtility.asList(DomainBaseEntities.Remark));
			map.put("FormDoc1", CollectionsUtility.asList(DomainBaseEntities.FormDoc1, DomainBaseEntities.FormDoc2, DomainBaseEntities.FormDoc3,
					DomainBaseEntities.FormDoc4, DomainBaseEntities.FormDoc5, DomainBaseEntities.FormDoc6, DomainBaseEntities.FormDoc7,
					DomainBaseEntities.FormDoc8, DomainBaseEntities.FormDoc9, DomainBaseEntities.FormDoc10));
			map.put("FormDoc2", CollectionsUtility.asList(DomainBaseEntities.FormDoc1, DomainBaseEntities.FormDoc2, DomainBaseEntities.FormDoc3,
					DomainBaseEntities.FormDoc4, DomainBaseEntities.FormDoc5, DomainBaseEntities.FormDoc6, DomainBaseEntities.FormDoc7,
					DomainBaseEntities.FormDoc8, DomainBaseEntities.FormDoc9, DomainBaseEntities.FormDoc10));
			map.put("FormDoc3", CollectionsUtility.asList(DomainBaseEntities.FormDoc1, DomainBaseEntities.FormDoc2, DomainBaseEntities.FormDoc3,
					DomainBaseEntities.FormDoc4, DomainBaseEntities.FormDoc5, DomainBaseEntities.FormDoc6, DomainBaseEntities.FormDoc7,
					DomainBaseEntities.FormDoc8, DomainBaseEntities.FormDoc9, DomainBaseEntities.FormDoc10));
			map.put("Customer", CollectionsUtility.asList(DomainBaseEntities.Customer));
			map.put("HOExitReEntryVisaReq", CollectionsUtility.asList(HREntities.HOExitReEntryVisaReq));
			map.put("Attendance", CollectionsUtility.asList(HREntities.ElectronicAttendance));
			map.put("MissionDocument", CollectionsUtility.asList(HREntities.MissionDocument));
			map.put("Vacation",
					CollectionsUtility.asList(HREntities.VacationDocument, HREntities.VacationRequest, HREntities.AggregatedVacationDocument,
							HREntities.AggregatedVacationRequest));
			map.put("HRLoanDocument", CollectionsUtility.asList(HREntities.HRLoanDocument, HREntities.HRLoanRequest));
			map.put("WorkStartingDocument", CollectionsUtility.asList(HREntities.WorkStartingDocument, HREntities.WorkStartingRequest,
					HREntities.AggregatedVacationStartingDoc));
			map.put("FiringDocument", CollectionsUtility.asList(HREntities.FiringDocument, HREntities.FiringRequest));
			map.put("Permission", CollectionsUtility.asList(HREntities.LeavePermission, HREntities.LeavePermissionReq));
			map.put("ElectronicReceipt", CollectionsUtility.asList(ACCEntities.ElectronicReceiptVoucher));
			List<String> salesDocuments = fetchSalesDocuments(considerSubItemDocuments);
			map.put("SalesOrder", salesDocuments);
			map.put("SalesDocument", salesDocuments);
			map.put("SalesInvoice", salesDocuments);
			map.put("SalesQuotation", salesDocuments);
			map.put("SalesQuotationRequest", salesDocuments);
			map.put("SalesReturn", CollectionsUtility.asList(SCEntities.SalesReturn, SCEntities.SalesReturnRequest));
			map.put("DeliveryDocument", CollectionsUtility.asList(SCEntities.DeliveryDocument));
			map.put("MaintenanceVisit", CollectionsUtility.asList(CRMEntities.MnVisit));
			map.put("Questionnaire", CollectionsUtility.asList(CRMEntities.CRMQuestionair));
			map.put("CRMVisit", CollectionsUtility.asList(CRMEntities.CRMVisit, CRMEntities.CRMVisitRequest));
			map.put("CRMComplaint", CollectionsUtility.asList(CRMEntities.CRMComplaint));
			map.put("StockReceipt", CollectionsUtility.asList(SCEntities.StockReceipt, SCEntities.StockReceiptReq));
			map.put("StockIssue", CollectionsUtility.asList(SCEntities.StockIssue, SCEntities.StockIssueReq));
			map.put("InternalStockTransfer", CollectionsUtility.asList(SCEntities.StockTransfer, SCEntities.StockTransferReq));
			map.put("ElectronicStockTaking", CollectionsUtility.asList(SCEntities.StockTakingElectronic));
			map.put("PurchaseInvoice", basicSCDocumentEntities);
			map.put("StockTransfer", CollectionsUtility.asList(SCEntities.StockTransfer, SCEntities.StockTransferReq));
			map.put("StockTransferRequest", CollectionsUtility.asList(SCEntities.StockTransfer, SCEntities.StockTransferReq));
			map.put("DLVDeliveryDocument", CollectionsUtility.asList(DomainBaseEntities.DLVDeliveryDocument));
			map.put("DamagedItemsDoc", basicSCDocumentEntities);
			map.put("AllocationFile", basicSCDocumentEntities);
			map.put("UserMobileIdentifierDocument", CollectionsUtility.asList(DomainBaseEntities.UserMobileIdentifierDocument));
			map.put("KitchenMeasurementVisit", CollectionsUtility.asList(CRMEntities.CRMVisit, CRMEntities.CRMVisitRequest));
			map.put("KitchenMaintenanceVisit", CollectionsUtility.asList(CRMEntities.MnNotice));
			map.put("KitchenDesign", CollectionsUtility.asList(CRMEntities.CRMQuestionair));
			map.put("KitchenSalesOrder", CollectionsUtility.asList(SCEntities.SalesOrder));
			map.put("KitchenCrmCall", CollectionsUtility.asList(CRMEntities.CRMCall));
			map.put("IssueStockTransfer", CollectionsUtility.asList(SCEntities.IssueStockTransfer));
			map.put("ReceiptStockTransfer", CollectionsUtility.asList(SCEntities.ReceiptStockTransfer));
			map.put("ResidenceRenewReq", CollectionsUtility.asList(HREntities.ResidenceRenewReq));
			map.put("MeetingRemark",
					CollectionsUtility.asList(BSCEntities.Subsidiary1, BSCEntities.Subsidiary2, BSCEntities.Subsidiary3, BSCEntities.Subsidiary4,
							BSCEntities.Subsidiary5, BSCEntities.DetailedRemark, BSCEntities.MobileAppAction, BSCEntities.Remark,
							BSCEntities.EmployeeAgenda, BSCEntities.MeetingRemark));
			map.put("DetailedRemark",
					CollectionsUtility.asList(BSCEntities.Subsidiary1, BSCEntities.Subsidiary2, BSCEntities.Subsidiary3, BSCEntities.Subsidiary4,
							BSCEntities.Subsidiary5, BSCEntities.DetailedRemark, BSCEntities.MobileAppAction, BSCEntities.Remark,
							BSCEntities.EmployeeAgenda, BSCEntities.MeetingRemark));
			map.put("KitchenElectronicReceipt", CollectionsUtility.asList(ACCEntities.ElectronicReceiptVoucher));
		}
		return map;
	}

	private static List<String> fetchSalesDocuments(boolean considerSubItemDocuments)
	{

		List<String> salesDocuments = CollectionsUtility.asList(SCEntities.SalesOrder, SCEntities.SalesInvoice, SCEntities.SalesQuotation,
				SCEntities.SalesQuotationRequest, SCEntities.ProformaSalesInvoice, SCEntities.DeliveryDocument, SCEntities.SalesReturn,
				SCEntities.SalesReturnRequest, SCEntities.SalesForecast, SCEntities.ReservationDocument, SCEntities.ReservationCancellationDoc,
				SCEntities.DeliveryCancellationDoc, SCEntities.Tender, SCEntities.CustomersReqsShortageDoc, SCEntities.LoadingDocument,
				SCEntities.LoadingCancellationDoc, SCEntities.SalesReplacement, SCEntities.SalesReplacementReq);
		if (considerSubItemDocuments)
		{
			salesDocuments.addAll(Arrays.asList(ServiceCenterEntities.SISalesInvoice, ServiceCenterEntities.SIProformaSalesInvoice,
					ServiceCenterEntities.SISalesOrder, ServiceCenterEntities.SISalesApproval, ServiceCenterEntities.SISalesOrderCancel,
					ServiceCenterEntities.SISalesReturn, ServiceCenterEntities.SITrafficLetter, ServiceCenterEntities.SITrafficLetterReq,
					ServiceCenterEntities.SITrafficLetterCancel, ServiceCenterEntities.SITrafficLetterReqCancel,
					ServiceCenterEntities.SISalesQuotation, ServiceCenterEntities.SISalesQuotationReq, ServiceCenterEntities.SIFinalDelivery,
					ServiceCenterEntities.SIFinalDeliveryCancel));
		}
		return salesDocuments;
	}

	private static List<String> allSalesDocuments;

	public static List<String> fetchSupportedMobileSalesDocs()
	{
		if (allSalesDocuments == null)
			allSalesDocuments = fetchSalesDocuments(true);
		return Collections.unmodifiableList(allSalesDocuments);
	}
}
