package com.namasoft.common.fieldids;

import com.namasoft.common.constants.CRMEntities;
import com.namasoft.common.utilities.*;

import java.util.*;

public abstract class MobileFieldCriteriaSuggester
{
	private static final Map<String, List<String>> map = new HashMap<>();

	public static Map<String, List<String>> fetchFieldIdSuggesterMap()
	{
		if (ObjectChecker.isEmptyOrNull(map))
		{
			map.put("MaintenanceVisit", CollectionsUtility.asList("customer", "machine", "mnOrder", "mnNotice"));
			map.put("StockReceipt", CollectionsUtility.asList("fromDoc"));
			map.put("PurchaseInvoice", CollectionsUtility.asList(CRMEntities.MnVisit));
			map.put("StockTransfer", CollectionsUtility.asList(CRMEntities.CRMQuestionair, "fromDoc"));
			map.put("InternalStockTransfer", CollectionsUtility.asList("fromDoc", "issueTransfer"));
			map.put("IssueStockTransfer", CollectionsUtility.asList("fromDoc"));
			map.put("ReceiptStockTransfer", CollectionsUtility.asList("fromDoc", "issueStockTransfer"));
			map.put("StockIssue", CollectionsUtility.asList("fromDoc"));
			map.put("DeliveryDocument", CollectionsUtility.asList("fromDoc"));
			List<String> salesDocumentsFields = CollectionsUtility.asList("fromDoc", "customer", "warehouse", "locator", "item");
			map.put("SalesReturn", salesDocumentsFields);
			map.put("SalesOrder", salesDocumentsFields);
			map.put("SalesDocument", salesDocumentsFields);
			map.put("SalesInvoice", salesDocumentsFields);
			map.put("SalesQuotation", salesDocumentsFields);
			map.put("SalesQuotationRequest", salesDocumentsFields);
			map.put("ElectronicReceipt", CollectionsUtility.asList("fromDoc", "customer", "currency", "ref1", "ref2", "ref3"));
			map.put("Permission", CollectionsUtility.asList("reason"));
			map.put("FiringDocument", CollectionsUtility.asList("reason"));
			map.put("WorkStartingDocument", CollectionsUtility.asList("vacationType", "fromDoc"));
			map.put("HRLoanDocument", CollectionsUtility.asList("loanType", "currency"));
			map.put("Vacation", CollectionsUtility.asList("reason", "vacationType"));
			map.put("Attendance", CollectionsUtility.asList("relatedTo"));
			map.put("HOExitReEntryVisaReq", CollectionsUtility.asList());
			map.put("Customer", CollectionsUtility.asList());
			map.put("Remark", CollectionsUtility.asList("customer"));
			map.put("ElectronicStockTaking", CollectionsUtility.asList("warehouse", "item"));
		}
		return map;
	}

	public static List<String> fetchScreenNameSuggester()
	{
		return CollectionsUtility.asList("ElectronicStockTaking","SalesQuotationRequest","SalesQuotation","SalesInvoice", "Remark", "Customer", "HOExitReEntryVisaReq", "Attendance", "Vacation", "HRLoanDocument",
				"WorkStartingDocument", "FiringDocument", "Permission", "ElectronicReceipt", "SalesOrder", "SalesReturn", "DeliveryDocument",
				"MaintenanceVisit", "StockReceipt", "PurchaseInvoice", "StockTransfer", "SalesDocument", "InternalStockTransfer",
				"StockTransferRequest", "StockReceipt", "StockIssue", "IssueStockTransfer", "ReceiptStockTransfer");
	}
}
