package com.namasoft.common.flatobjects;

import com.namasoft.common.IBaseEntityDTO;
import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.tempo.*;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.tafqeet.Converter;

import java.lang.reflect.*;
import java.math.BigDecimal;
import java.text.*;
import java.util.*;
import java.util.regex.Pattern;

public class BasicObjectPropertyResolver implements RendererPropertyResolver
{
	private final Object object;
	public static String SEPARATOR = ".";
	private static String DOT = Pattern.quote(".");

	public BasicObjectPropertyResolver(Object object)
	{
		this.object = object;
	}

	@Override
	public String resolve(String property, int rowNumber, boolean insideCreator, RenderNode calledFrom)
	{
		Object object = resolveObject(property, rowNumber);
		return ObjectChecker.toStringOrEmpty(object);
	}

	@Override
	public String createPaymentUrl(Object document, Object config)
	{
		return null;
	}

	@Override
	public Object resolveObject(String property, int rowNumber)
	{
		property = property.trim();
		if ("@rownumber".equalsIgnoreCase(property))
			return rowNumber + 1;
		FieldValueConsideringListsResult retValue = extractFieldValueConsideringList(property);
		if (ObjectChecker.isEmptyOrNull(retValue) || ObjectChecker.isEmptyOrNull(retValue.getResult()))
			return null;
		if (retValue.getResult().size() > 1 && retValue.getResult().size() <= rowNumber)
		{
			return null;
		}
		Object object;
		if (retValue.getResult().size() == 1)
			object = retValue.getResult().get(0);
		else if (retValue.getResult().size() > rowNumber)
			object = retValue.getResult().get(rowNumber);
		else
			return null;

		return object;
	}

	private FieldValueConsideringListsResult extractFieldValueConsideringList(String property)
	{
		property = property.trim();
		Object source = this.object;

		FieldValueConsideringListsResult retValue;
		if (property.startsWith("$this"))
		{
			retValue = new FieldValueConsideringListsResult();
			retValue.getResult().add(source);
		}
		//		else if (property.startsWith("$user"))
		//		{
		//			if (property.equals("$user"))
		//			{
		//				retValue = new FieldValueConsideringListsResult();
		//				retValue.getResult().add(NaMaContext.getCurrentContext().getCurrentUser());
		//			}
		//			else
		//			{
		//				property = property.replace("$user.", "");
		//				retValue = EntityReflection
		//						.getFieldValueConsideringLists(FieldID.fromString(property), NaMaContext.getCurrentContext().getCurrentUser());
		//			}
		//		}
		else
		{
			retValue = getFieldValueConsideringLists(property, source);
		}
		if (ObjectChecker.isEmptyOrNull(retValue))
		{
			NaMaLogger.warn("Property " + property + " Not found for object " + source);
			return null;
		}
		if (retValue.getResult().size() == 1 && retValue.getResult().get(0) instanceof List)
		{
			retValue.setResult((List<?>) retValue.getResult().get(0));
		}

		return retValue;
	}

	private FieldValueConsideringListsResult getFieldValueConsideringLists(String property, Object source)
	{
		String[] parts = property.split(DOT);
		Object current = source;
		try
		{
			for (int i = 0; i < parts.length; i++)
			{
				String part = parts[i];
				current = extractSingleFieldValue(current, part);
				if (current instanceof List)
				{
					FieldValueConsideringListsResult result = new FieldValueConsideringListsResult();
					result.setHasLists(true);
					List list = (List) current;
					result.setResult(new ArrayList(list.size()));
					String remainingFields = "";
					for (int j = i + 1; j < parts.length; j++)
					{
						if (ObjectChecker.isEmptyOrNull(remainingFields))
							remainingFields = parts[j];
						else
							remainingFields = remainingFields + "." + parts[j];
					}
					for (Object o : list)
					{
						result.getResult().add(getFieldValue(remainingFields, o));
					}
					return result;
				}
			}
		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
		FieldValueConsideringListsResult result = new FieldValueConsideringListsResult();
		result.setHasLists(false);
		result.setResult(new ArrayList());
		result.getResult().add(current);
		return result;
	}

	private <T> T getFieldValue(String fieldName, Object source)
	{
		if (ObjectChecker.isEmptyOrNull(fieldName))
			return (T) source;
		String[] parts = fieldName.split(DOT);
		Object current = source;
		try
		{
			for (String part : parts)
			{
				current = extractSingleFieldValue(current, part);
			}
		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
		return (T) current;
	}

	private Object extractSingleFieldValue(Object current, String part)
			throws NoSuchMethodException, IllegalAccessException, InvocationTargetException
	{
		if (current == null)
			return null;
		String methodName = part;
		if (!part.startsWith("$"))
			methodName = "get" + StringUtils.firstLetterUpper(part);
		Method m = current.getClass().getMethod(methodName);
		return m.invoke(current);
	}

	@Override
	public int calcSizeForLoop(String loopDetailName)
	{
		List<?> list = getFieldValue(loopDetailName, object);
		if (list == null)
			return 0;
		return list.size();
	}

	@Override
	public int listSize(String varName)
	{
		FieldValueConsideringListsResult list = extractFieldValueConsideringList(varName);
		if (ObjectChecker.isEmptyOrNull(list) || ObjectChecker.isEmptyOrNull(list.getResult()))
			return 0;
		return list.getResult().size();
	}

	@Override
	public INotificationInfo calcNotificationInfo(int currentLineNumber)
	{
		return null;
	}

	@Override
	public String marshalInString(Object object)
	{
		return null;
	}

	@Override
	public void loopStart(StringBuilder builder)
	{

	}

	@Override
	public void loopIterationStart(StringBuilder builder)
	{

	}

	@Override
	public void loopIterationEnd(StringBuilder builder)
	{

	}

	@Override
	public void loopEnd(StringBuilder builder)
	{

	}

	@Override
	public <T> Comparable<T> toDecimal(Object o)
	{
		if (o instanceof BigDecimal)
			return (Comparable<T>) o;
		if (ObjectChecker.isEmptyOrNull(o))
			return (Comparable<T>) BigDecimal.ZERO;
		return (Comparable<T>) new BigDecimal(o.toString());
	}

	@Override
	public int compareValues(Object lhs, Object rhs, boolean numeric)
	{
		if (numeric)
			return toDecimal(lhs).compareTo(toDecimal(rhs));
		if (lhs instanceof Date && rhs instanceof Date)
			return ((Date) lhs).compareTo((Date) rhs);
		if (lhs instanceof Boolean && rhs instanceof Boolean)
			return ((Boolean) lhs).compareTo((Boolean) rhs);
		if (lhs instanceof Number && rhs instanceof Number)
			return Double.compare(((Number) lhs).doubleValue(), ((Number) rhs).doubleValue());
		if (lhs instanceof Date && rhs instanceof Date)
			return ((Date) lhs).compareTo((Date) rhs);
		return ObjectChecker.toStringOrEmpty(lhs).compareTo(ObjectChecker.toStringOrEmpty(rhs));
	}

	@Override
	public boolean isTrueIfCondition(Object object)
	{
		if (ObjectChecker.isEmptyOrNull(object))
			return false;
		if (object instanceof Boolean)
			return ObjectChecker.isTrue((Boolean) object);
		if (object instanceof Number)
			return ((Number) object).intValue() != 0;
		String str = ObjectChecker.toStringOrEmpty(object);
		if (str.equalsIgnoreCase("true"))
			return true;
		if (str.equalsIgnoreCase("false"))
			return false;
		return ObjectChecker.isNotEmptyOrNull(str);
	}

	@Override
	public void tafqeet(Object value, Object currencyObj, StringBuilder builder, Language language)
	{
		BigDecimal number = new BigDecimal(ObjectChecker.toStringOrEmpty(value));
		String currencyCode = "";
		if (currencyObj instanceof IBaseEntityDTO)
			currencyCode = ((IBaseEntityDTO) currencyObj).getCode();
		else
			currencyCode = ObjectChecker.toStringOrEmpty(currencyObj);

		builder.append(Converter.convertToWords(number, currencyCode, language));
	}

	@Override
	public String calcSalesPriceForCustomer(ItemSalesPriceNode itemPriceNode, int currentLineNumber)
	{
		return null;
	}

	@Override
	public String calcPurchasePriceForSupplier(ItemPurchasePriceNode itemPriceNode, int currentLineNumber)
	{
		return null;
	}

	@Override
	public ExtractLinkInfo extractLinkInfo(Object first, Object entityType, Object id, Object title)
	{
		return null;
	}

	@Override
	public void round(Object number, Object fractionalDecimalPlaces, StringBuilder builder)
	{
		BigDecimal n = NaMaMath.toBigDecimal(number);
		BigDecimal places = NaMaMath.toBigDecimal(fractionalDecimalPlaces);
		builder.append(NaMaMath.round(n, places.intValue()));
	}

	@Override
	public void formatNumber(Object o, String format, StringBuilder builder)
	{
		BigDecimal n = NaMaMath.toBigDecimal(o);
		builder.append(new DecimalFormat(format).format(n));
	}

	@Override
	public void formatDate(Object o, String format, StringBuilder builder)
	{
		builder.append(new SimpleDateFormat(format).format(o));
	}

	@Override
	public void enableDetailSqlFields(String collectionName)
	{
	}

	@Override
	public void clearFactoryFieldPrefixes()
	{
	}

	public static class FieldValueConsideringListsResult<T>
	{
		private boolean hasLists = false;
		private List<T> result = new ArrayList<T>();

		public boolean isHasLists()
		{
			return hasLists;
		}

		public void setHasLists(boolean hasLists)
		{
			this.hasLists = hasLists;
		}

		public List<T> getResult()
		{
			return result;
		}

		public void setResult(List<T> result)
		{
			this.result = result;
		}

	}

	private static String[] getPathParts(String fieldId)
	{
		String[] parts = (fieldId + SEPARATOR).split("\\.");
		return parts;

	}

	private <T> FieldValueConsideringListsResult<T> getFieldValueConsideringLists(String fieldId, Object root,
			FieldValueConsideringListsResult<T> result, boolean addNullsIfFound)
	{
		String[] pathParts = getPathParts(fieldId);
		Object currentObject = root;
		List<T> list = result.getResult();
		for (int i = 0; i < pathParts.length; i++)
		{
			if (currentObject instanceof Map)
			{
				currentObject = ((Map) currentObject).get(pathParts[i]);
			}
			else
			{
				try
				{
					currentObject = getFieldValue(pathParts[i], currentObject);
				}
				catch (Exception e)
				{
					NaMaLogger.info("Could not find field " + fieldId, e);
					currentObject = null;
				}
			}
			if (currentObject == null)
			{
				if (addNullsIfFound)
					list.add(null);
				return result;
			}

			if (i == pathParts.length - 1)
			{
				list.add((T) currentObject);
			}
			else if (currentObject instanceof Collection && !(currentObject instanceof Map))
			{
				result.setHasLists(true);
				for (Object line : (Collection<Object>) currentObject)
				{
					getFieldValueConsideringLists(fromPath(pathParts, i + 1), line, result, true);
				}
				break;
			}
		}
		return result;
	}

	public static String fromPath(String[] path, int startIndex)
	{
		int endIndex = path.length;
		return fromPath(path, startIndex, endIndex);
	}

	public static String fromPath(String[] path, int startIndex, int endIndex)
	{
		if (endIndex <= startIndex)
		{
			return null;
		}
		String id = path[startIndex];
		for (int i = startIndex + 1; i < endIndex; i++)
		{
			id = id + SEPARATOR + path[i];
		}
		return id;
	}
}
