package com.namasoft.common.flatobjects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("rawtypes")
public class GenericList implements Serializable
{

	private static final long serialVersionUID = 8538640305224624010L;
	private DataTypes dataType;
	private String parantDetail;
	private List<Object> list;
	@SuppressWarnings("unused")
	private FlatObject dummy;

	public static GenericList createFromFlatObjectList(FlatObjectList list, String parantDetail)
	{
		GenericList fieldGenericList = new GenericList();
		if (list == null)
			return fieldGenericList;
		fieldGenericList.setParantDetail(parantDetail);
		fieldGenericList.setList(list.getList());
		fieldGenericList.setDataType(DataTypes.FLATOBJECTLIST);
		return fieldGenericList;
	}

	@SuppressWarnings("unchecked")
	public static GenericList createFromList(List list, String parantDetail)
	{
		GenericList fieldGenericList = new GenericList();
		if (list == null)
			return fieldGenericList;
		fieldGenericList.setParantDetail(parantDetail);
		fieldGenericList.setList(list);
		fieldGenericList.setDataType(DataTypes.NORMALLIST);
		return fieldGenericList;
	}

	public GenericList()
	{
	}

	public DataTypes getDataType()
	{
		return dataType;
	}

	public void setDataType(DataTypes dataType)
	{
		this.dataType = dataType;
	}

	public String getParantDetail()
	{
		return parantDetail;
	}

	public void setParantDetail(String parantDetail)
	{
		this.parantDetail = parantDetail;
	}

	public List<Object> getList()
	{
		return list;
	}

	public void setList(List<Object> list)
	{
		this.list = list;
	}

	public Object getFieldValue()
	{
		if (DataTypes.FLATOBJECTLIST.equals(getDataType()))
			return new FlatObjectList(convertColumnValuesToReal());
		else
			return getList();

	}

	private List convertColumnValuesToReal()
	{
		List<Object> listOfGenerics = getList();
		return listOfGenericsToRealValues(listOfGenerics);
	}

	public static List listOfGenericsToRealValues(List<Object> listOfGenerics)
	{
		if(listOfGenerics == null)
			return new ArrayList();
		List<Object> list = new ArrayList<>();
		for (Object object : listOfGenerics)
		{
			if (object instanceof GenericValue)
				list.add(((GenericValue) object).calcFieldValue());
			else
				list.add(object);
		}
		return list;
	}

	@Override
	public String toString()
	{
		if (list != null)
			return list.toString();
		return "" + dataType;
	}
}
