package com.namasoft.common.flatobjects;

import com.namasoft.common.utilities.ObjectChecker;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public interface IDTOTask extends Serializable
{
	Date getStartTime();

	EntityReferenceData getUser();

	String getMessage();

	String getFromIP();

	String getTaskId();

	void setMarkedForKill(boolean markedForKill);

	void setMarkedForKillOn(Date markedForKillOn);

	Date getMarkedForKillOn();

	boolean isMarkedForKill();

	String getProgress();

	default void markForKill()
	{
		setMarkedForKill(true);
		setMarkedForKillOn(new Date());
	}

	default String calcMessage()
	{
		if (ObjectChecker.isNotEmptyOrNull(getProgress()))
			return getMessage() + " - " + getProgress();
		return getMessage();
	}

	void updateProgress(String progress);

	default BigDecimal calcElapsed()
	{
		return new BigDecimal(System.currentTimeMillis() - getStartTime().getTime()).divide(new BigDecimal(1000), 3, BigDecimal.ROUND_HALF_UP);
	}
}