package com.namasoft.common.flatobjects;

import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.*;
@XmlAccessorType(XmlAccessType.FIELD)
public class NamaExcelSheet
{
	private List<NamaExcelRow> rawRows = new ArrayList<>();
	private String name;
	private Integer index;
	@XmlTransient
	private List<NamaExcelRow> filteredRows;

	public NamaExcelSheet()
	{
	}

	public NamaExcelSheet(String sheetName, int sheetIndex)
	{
		this.name = sheetName;
		this.index = sheetIndex;
	}

	public List<NamaExcelRow> getRawRows()
	{
		return rawRows;
	}

	public void setRawRows(List<NamaExcelRow> rawRows)
	{
		this.rawRows = rawRows;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Integer getIndex()
	{
		return index;
	}

	public void setIndex(Integer index)
	{
		this.index = index;
	}

	public void addRow(List<String> line)
	{
		rawRows.add(new NamaExcelRow(line, rawRows.size() + 1));
	}

	public List<NamaExcelRow> getRows()
	{
		return filteredRows == null ? getRawRows() : filteredRows;
	}

	public void resetFilteredRows()
	{
		this.filteredRows = null;
	}

	public void ignoreLinesFromTop(Integer lines)
	{
		if (lines == null)
			return;
		if (filteredRows == null)
			filteredRows = rawRows;
		if (lines >= filteredRows.size())
			filteredRows = filteredRows.subList(0, 0);
		filteredRows = filteredRows.subList(lines, filteredRows.size());
	}

	public void ignoreLinesFromBottom(Integer lines)
	{
		if (lines == null)
			return;
		if (filteredRows == null)
			filteredRows = rawRows;
		filteredRows = filteredRows.subList(0, filteredRows.size() - lines);
	}

	public NamaExcelRow getRowAtOneBasedIndex(Integer oneBasedIndex)
	{
		if (ObjectChecker.isEmptyOrZero(oneBasedIndex) || oneBasedIndex > getRows().size())
			return null;
		return getRows().get(oneBasedIndex - 1);
	}

	public boolean rowContainsNonEmptyCells_oneBased(Integer oneBasedIndex)
	{
		NamaExcelRow row = getRowAtOneBasedIndex(oneBasedIndex);
		return row != null && row.containsNonEmptyCells();
	}
}
