package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.PlaceTokens;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.utilities.*;

import java.util.*;

abstract class AbsLinkNode extends RenderNode
{
	private final String nodeContent;
	private final String firstParameter;
	private String secondParameter;
	private String menuCode;
	private String viewCode;
	private String flowCode;
	private String paymentConfigCode;
	private String plainLink;
	private String targetExpression;
	private String imgWidth;
	private String imgHeight;
	private String itemCode;

	public String getFirstParameter()
	{
		return firstParameter;
	}

	public String getPaymentConfigCode()
	{
		return paymentConfigCode;
	}

	public boolean isPlainLink()
	{
		return renderer.isPlainLinks() || ObjectChecker.isTrue(plainLink);
	}

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(firstParameter, secondParameter, menuCode, viewCode, flowCode, paymentConfigCode, targetExpression, itemCode);
	}

	public AbsLinkNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		firstParameter = parts.get(0);
		for (int i = parts.size() - 1; i > 0; i--)
		{
			if (parts.get(i).trim().startsWith("menu="))
			{
				menuCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("view="))
			{
				viewCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("flowcode="))
			{
				flowCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("paymentconfigcode="))
			{
				paymentConfigCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("plainlink="))
			{
				plainLink = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("newwindow="))
			{
				targetExpression = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("width="))
			{
				imgWidth = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("height="))
			{
				imgHeight = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("itemcode="))
			{
				itemCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
		}
		if (parts.size() > 1 && !parts.get(1).contains("="))
			secondParameter = parts.get(1);
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		Object first;
		if (firstParameter.startsWith("\""))
			first = renderer.evalConstantOrVar(firstParameter, helper, currentLineNumber, insideCreator(), this);
		else
			first = helper.resolveObject(firstParameter, currentLineNumber);
		Object entityType = null;
		Object id = "";
		Object title = "";
		ExtractLinkInfo extractLinkInfo = helper.extractLinkInfo(first, entityType, id, title);
		entityType = extractLinkInfo.getEntityType();
		id = extractLinkInfo.getId();
		title = extractLinkInfo.getTitle();
		if (ObjectChecker.isNotEmptyOrNull(secondParameter))
			id = renderer.evalConstantOrVar(secondParameter, helper, currentLineNumber, insideCreator(), this);
		StringBuilder innerBuilder = new StringBuilder();
		renderSubNodes(innerBuilder, helper, currentLineNumber);
		if (ObjectChecker.isNotEmptyOrNull(innerBuilder.toString()))
		{
			title = innerBuilder.toString();
		}
		String resolvedMenuCode = null;
		String resolvedView = null;
		String resolvedFlowCode = null;
		if (ObjectChecker.isNotEmptyOrNull(menuCode))
		{
			resolvedMenuCode = renderer.evalConstantOrVar(menuCode, helper, currentLineNumber, insideCreator(), this);
		}
		if (ObjectChecker.isNotEmptyOrNull(viewCode))
		{
			resolvedView = renderer.evalConstantOrVar(viewCode, helper, currentLineNumber, insideCreator(), this);
		}
		if (ObjectChecker.isNotEmptyOrNull(flowCode))
		{
			resolvedFlowCode = renderer.evalConstantOrVar(flowCode, helper, currentLineNumber, insideCreator(), this);
		}
		String url = renderer.calcGUIURL();
		String targetWindow = "";

		if (ObjectChecker.isNotEmptyOrNull(targetExpression))
		{
			if (ObjectChecker.isNotEmptyOrNull(renderer.evalConstantOrVar(targetExpression, helper, currentLineNumber, insideCreator(), this)))
				targetWindow = " target='_blank' ";
		}
		LinkCreationParameters creationParameters = new LinkCreationParameters(builder, url, entityType, id, resolvedMenuCode, resolvedView,
				resolvedFlowCode, targetWindow, title);
		creationParameters.setImgHeight(renderer.evalConstantOrVar(imgHeight, helper, currentLineNumber, insideCreator(), this));
		creationParameters.setImgWidth(renderer.evalConstantOrVar(imgWidth, helper, currentLineNumber, insideCreator(), this));
		creationParameters.setItemCode(renderer.evalConstantOrVar(itemCode, helper, currentLineNumber, insideCreator(), this));
		renderLink(creationParameters);
	}

	protected void renderLink(LinkCreationParameters linkCreationParameters)
	{
		if (isPlainLink())
		{
			linkCreationParameters.getBuilder().append(linkCreationParameters.getUrl())
					.append(getPlaceToken(linkCreationParameters.getEntityType(), linkCreationParameters.getId(),
							linkCreationParameters.getResolvedMenuCode(), linkCreationParameters.getResolvedView(),
							linkCreationParameters.getResolvedFlowCode()));
			return;
		}
		linkCreationParameters.getBuilder().append("<a href='").append(linkCreationParameters.getUrl())
				.append(getPlaceToken(linkCreationParameters.getEntityType(), linkCreationParameters.getId(),
						linkCreationParameters.getResolvedMenuCode(), linkCreationParameters.getResolvedView(),
						linkCreationParameters.getResolvedFlowCode())).append("' ").append(linkCreationParameters.getTargetWindow()).append(">")
				.append(linkCreationParameters.getTitle()).append("</a>");
	}

	protected String getPlaceToken(Object entityType, Object id, String resolvedMenuCode, String resolvedView, String resolvedFlowCode)
	{
		return PlaceTokens.getEditPlaceTokenWithMenu(ObjectChecker.toStringOrEmpty(entityType), ObjectChecker.toStringOrEmpty(id), resolvedMenuCode,
				resolvedView);
	}

}
