package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;

import java.util.*;

public class IfEqualNode extends AbstractIfNode
{
	protected final String leftSideVarName;
	protected final String rightSideVarName;
	protected final boolean numeric;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(leftSideVarName, rightSideVarName);
	}

	public IfEqualNode(String nodeContent)
	{
		super(nodeContent);
		this.numeric = nodeContent.toLowerCase().contains("ifnumber");
		String conditionBody = StringUtils.getInnerString(condition, "(", ")");
		this.leftSideVarName = StringUtils.substringBefore(conditionBody, ",");
		this.rightSideVarName = StringUtils.substringAfter(conditionBody, ",");
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	protected boolean checkCondition(Object leftSideValue, Object rightSideValue, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (numeric)
			return ObjectChecker.areEqual(helper.toDecimal(leftSideValue), helper.toDecimal(rightSideValue));
		return ObjectChecker.areEqual(ObjectChecker.toStringOrEmpty(leftSideValue), ObjectChecker.toStringOrEmpty(rightSideValue));
	}

	@Override
	protected boolean checkCondition(RendererPropertyResolver helper, int currentLineNumber)
	{
		Object leftSideValue = renderer.evalConstantOrVar(leftSideVarName, helper, currentLineNumber, insideCreator(), this);
		Object rightSideValue = renderer.evalConstantOrVar(rightSideVarName, helper, currentLineNumber, insideCreator(), this);
		return checkCondition(leftSideValue, rightSideValue, helper, currentLineNumber);
	}
}
