package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class IfLessNode extends IfEqualNode
{
	public IfLessNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	protected boolean checkCondition(Object leftSideValue, Object rightSideValue, RendererPropertyResolver helper, int currentLineNumber)
	{
		if (ObjectChecker.areAllEmptyOrNull(leftSideValue, rightSideValue))
			return false;
		return helper.compareValues(leftSideValue, rightSideValue, numeric) < 0;
	}
}
