package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.StringUtils;

import java.util.*;

public class IfNode extends AbstractIfNode
{
	protected final String varName;

	@Override
	public List<String> collectVariables()
	{
		return Collections.singletonList(varName);
	}

	public IfNode(String nodeContent)
	{
		super(nodeContent);
		this.varName = StringUtils.getInnerString(condition, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	protected boolean checkCondition(RendererPropertyResolver helper, int currentLineNumber)
	{
		Object conditionValue = helper.resolveObject(varName, currentLineNumber);
		return checkCondition(conditionValue, helper, currentLineNumber);
	}

	protected boolean checkCondition(Object conditionValue, RendererPropertyResolver helper, int currentLineNumber)
	{
		return helper.isTrueIfCondition(conditionValue);
	}
}
